package components.Tools
{
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	//import flash.display.BlendMode;
	
	// Esta classe cria os textos do componente
	// embedFonts esta ligado para permitir rotação de texto
	// no componente é que estao sendo embuidas as fontes.
	public class BannerText extends Sprite{
		public var txt:TextField;
		public var fmt:TextFormat;
		public var container:Sprite = new Sprite();
		
		public function BannerText(col:uint, fnt:String='Arial', siz:int=12){
			txt = new TextField();
			fmt = new TextFormat();
			fmt.size = siz;
			fmt.color = col;
			fmt.font = fnt;
			txt.text = "Clique aqui para editar o seu texto.";
			txt.multiline = true;
			txt.autoSize = TextFieldAutoSize.LEFT;
			txt.type = TextFieldType.DYNAMIC;
			txt.setTextFormat(fmt);
			txt.selectable = false;
			txt.name = 'txts';
			txt.embedFonts = true;
			//container.blendMode = BlendMode.LAYER; // tentativa de resolver o alpha de fontes dinamicas. Unica solucao foi embuir as fontes
			addChild(txt);
			//addChild(container);
		}
		public function getText():String{
			return txt.text;
		}
		public function changeFill(col:uint):void{
			fmt.color = col;
			txt.setTextFormat(fmt);
		}
		public function changeFont(fnt:String, val:String):void{
			switch(fnt){
				case 'text':
					txt.text = val;
				break;
				case 'font':
					fmt.font = val;
				break;
				case 'color':
					fmt.color = uint(val);
				break;
				case 'size':
					fmt.size = Number(val);
				break;
				case 'bold':
					fmt.bold = !fmt.bold;
				break;
				case 'italics':
					fmt.italic = !fmt.italic;
				break;
				case 'underline':
					fmt.underline = !fmt.underline;
				break;
			}
			txt.setTextFormat(fmt);
		}
	}
}