package components.Tools
{
	import flash.display.Sprite

	public class BannerRectangle extends Sprite{
		public var fillColor:uint;
		private var Width:Number;
		private var Height:Number;
		private var fillAlpha:Number;
		public var lineColor:uint;
		public var lineWidth:Number;
		private var lineAlpha:Number;
		private var XPos:Number;
		private var YPos:Number;
		
		public function BannerRectangle(fCol:uint,w:Number,h:Number,fAlpha:Number,lCol:uint,lWidth:Number,lAlpha:Number){
			paint(fCol,w,h,fAlpha,lCol,lWidth,lAlpha);
		}
		private function paint(fCol:uint,w:Number,h:Number,fAlpha:Number,lCol:uint,lWidth:int,lAlpha:Number,xPos:Number=0,yPos:Number=0):void{
			this.graphics.lineStyle(lWidth, lCol, lAlpha);
			this.graphics.beginFill(fCol, fAlpha);
			this.graphics.drawRect(xPos, yPos, w, h);
			this.graphics.endFill();
			//Now store the exact parameters should in case you need to redraw later...
			fillColor = fCol;
			Width = w;
			Height = h;
			fillAlpha = fAlpha;
			lineColor = lCol;
			lineWidth = lWidth;
			lineAlpha = lAlpha;
			XPos = xPos;
			YPos = yPos
		}
		public function changeFill(col:uint):void{
			this.graphics.clear();
			paint(col,Width,Height,fillAlpha,lineColor,lineWidth,lineAlpha,XPos,YPos);
		}
		public function changeLine(col:uint,thick:Number):void{
			this.graphics.clear();
			paint(fillColor,Width,Height,fillAlpha,col,thick,lineAlpha,XPos,YPos);
		}
		public function redraw(fCol:uint,fAlpha:Number,lCol:uint,lWidth:Number,lAlpha:Number):void{
			this.graphics.clear();
			var tempW:Number, tempH:Number;
			tempW = (mouseX > 0) ? mouseX : -1 * mouseX;
			tempH = (mouseY > 0) ? mouseY : -1 * mouseY;
			var xPos:Number, yPos:Number;
			xPos = (mouseX > 0) ? 0 : mouseX;
			yPos = (mouseY > 0) ? 0 : mouseY;
			paint(fCol,tempW,tempH,fAlpha,lCol,lWidth,lAlpha,xPos,yPos);
		}
	}
}