<?php
/*******************************************************************************************************
*
* pagseguro.php 12/03/2006
*
* Módulo de Pagamento osCommerce 2.2 para aprovar Cartões de Crédito através do serviço pagseguro brasileiro
*
* Author: Claudio H. Imai <imai@creativstudios.org>
* March, 2006
* Alterações feitaspor Valmy Gomes em 24/04/2008 - valmygomes@legalzona.com.br
* Copyright (c) 2006 Creativstudios Web Solutions <suporte@creativstudios.org>
* Copyright (c) 2002 osCommerce
*
* Released under the GNU General Public License
* 
* versão 1.5
* Descrição:
* Adicionado um campo de status dos pedidos com pagamento aprovado.
* O módulo anterior não separava entre pagamentos em aberto ou aprovados, tendo de ser alterado manualmente
* no momento do processamento do pedido.
* Isso significava que se a loja vende produtos por download, o cliente deveria esperar a autorização manual
* do pagamento.
* Corrigida a atualização do pedido no segundo post do servidor. Agora é feito logo após o primeiro POST, porque o método anterior
* não atualizava o status do pedido se o cliente fechasse a janela antes de voltar para a loja.
* 
* em aberto: Foram criados dois novos campos para serem valores a somar no pedido, a fim de cobrir as
* taxas cobradas pelo pagseguro ao lojista. Notificar ao comprador dessa possibilidade, se o lojista optar
* pelo uso desses valores.
* 
* Atualização:
* 1. DESINSTALE o módulo anterior da loja (na administração);
* 2. sobrescreva os arquivos referentes ao módulo, via ftp;
* 3. reinstale o módulo novo;
* 4. crie um novo status de pedido para pagamentos aprovados;
* 5. Reconfigure o módulo como descrito nas instruções de instalação, tomando o cuidado de alterar o campo de "Pedidos aprovados" de acordo com sua configuração.
*
* Em caso de dúvidas, verique nossa documentação em www.creativstudios.org ou no forum.
********************************************************************************************************/
  class pagseguro {
    var $code, $title, $description, $enabled;
// class constructor
    function pagseguro() {
      global $order;
      $this->code = 'pagseguro';
      $this->title = MODULE_PAYMENT_PAGSEGURO_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_PAGSEGURO_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_PAGSEGURO_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_PAGSEGURO_STATUS == 'True') ? true : false);
      if ((int)MODULE_PAYMENT_PAGSEGURO_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_PAGSEGURO_ORDER_STATUS_ID;
      }
      if (is_object($order)) $this->update_status();
// URL for transaction. In this case, the parameters are sent to a CGI, so the URL is checkout_process.php
// If the parameters were to be sent as POST variables, the URL would be different. See paypal_ipn contribution for an example.
// Claudio Mar, 18th, 2006
//      $this->form_action_url = tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL', true);
      $this->form_action_url = "https://pagseguro.uol.com.br/security/webpagamentos/webpagto.aspx";
    }
// class methods
    function update_status() {
      global $order;
      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_PAGSEGURO_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_PAGSEGURO_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }
        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }
    function javascript_validation() {
      return true;
    }
/*******************************************************************************
* function to handle options before exchanging data with the payment gateway
* Payment information screen
* ******************************************************************************/
    function selection() {
      global $order;
      $shipping_cost = $order->info['shipping_cost'];
      $pagseguro_image = "https://pagseguro.uol.com.br/Security/Imagens/".(MODULE_PAYMENT_PAGSEGURO_CREDIT_CARD=='True'?"btnWebprefC.gif":"btnWebpref.gif");
      $fields = array();
      $fields[] = array('title' => 'Pagamento via PagSeguro',
                        'text'  => "Finalize seu pagamento no site seguro do PagSeguro, e proteja-se de fraudes.");
      $fields[] = array('title' => 'Modos de pagamento aceitos:',
                        'text'  => '');
      $fields[] = array('title' => '<a href="https://pagseguro.uol.com.br/?ind=632613"  target="blank"><img src="'.$pagseguro_image.'" width="300" border="0"></a>',
                        'text'  => '');
      if (MODULE_PAYMENT_PAGSEGURO_SHIPPING=="True") { // Cálculo do frete pelo PagSeguro habilitado
          $tipoFretes = array (array('id' => 'EN',
                                     'text' => 'Encomenda Normal'),
                               array('id' => 'SD',
                                     'text' => 'Sedex'));
          if (($shipping_cost>0)&&false) { // desativado enquanto não aceita escolha caso a caso.
              $fields[] = array('title' => "&nbsp;&nbsp;Cálculo de frete padrão",
                                'field' => tep_draw_radio_field("calcfrete", "LOJA", TRUE));
              $fields[] = array('title' => "&nbsp;&nbsp;Cálculo de frete pelo PagSeguro",
                                'field' => tep_draw_radio_field("calcfrete", "PAGSEGURO"));
          } else {
              $fields[] = array('title' => "&nbsp;&nbsp;Cálculo de frete pelo PagSeguro",
                                'field' => tep_draw_hidden_field("calcfrete", "PAGSEGURO", true));
          }
          $fields[] = array('title' => '&nbsp;&nbsp;&nbsp;&nbsp;Tipo de frete',
                            'field' => tep_draw_pull_down_menu('TipoFrete', $tipoFretes));
      }
      $selection = array('id' => $this->code,
                         'module' => $this->title,
                         'fields' => $fields);
      return $selection;
    }
/*************************************************************
* Checks the data in the Payment selection screen
* Validate data from this->selection() function
* if data is incorrect, return to checkout payment screen
* and prompt user for the incorrect data.
* ************************************************************/
    function pre_confirmation_check() {
		return false;
    }
/******************************************
* Function in the order confirmation screen
* *****************************************/
    function confirmation() {
      global $HTTP_POST_VARS, $cartID, $cart_pagseguro_ID, $customer_id, $languages_id, $order, $order_total_modules, $insert_id;
      $confirmation = array('title' => $this->title . ': ',
                            'fields' => array(array('title' => MODULE_PAYMENT_PAGSEGURO_TEXT_OUTSIDE,
                                                    'field' => "")));
      if (tep_session_is_registered('cartID')) {
        $insert_order = false;
        if (tep_session_is_registered('cart_pagseguro_ID')) {
          $order_id = substr($cart_pagseguro_ID, strpos($cart_pagseguro_ID, '-')+1);
          $curr_check = tep_db_query("select currency from " . TABLE_ORDERS . " where orders_id = '" . (int)$order_id . "'");
          $curr = tep_db_fetch_array($curr_check);
          if ( ($curr['currency'] != $order->info['currency']) || ($cartID != substr($cart_pagseguro_ID, 0, strlen($cartID))) ) {
            $check_query = tep_db_query('select orders_id from ' . TABLE_ORDERS_STATUS_HISTORY . ' where orders_id = "' . (int)$order_id . '" limit 1');
            if (tep_db_num_rows($check_query) < 1) {
              tep_db_query('delete from ' . TABLE_ORDERS . ' where orders_id = "' . (int)$order_id . '"');
              tep_db_query('delete from ' . TABLE_ORDERS_TOTAL . ' where orders_id = "' . (int)$order_id . '"');
              tep_db_query('delete from ' . TABLE_ORDERS_STATUS_HISTORY . ' where orders_id = "' . (int)$order_id . '"');
              tep_db_query('delete from ' . TABLE_ORDERS_PRODUCTS . ' where orders_id = "' . (int)$order_id . '"');
              tep_db_query('delete from ' . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . ' where orders_id = "' . (int)$order_id . '"');
              tep_db_query('delete from ' . TABLE_ORDERS_PRODUCTS_DOWNLOAD . ' where orders_id = "' . (int)$order_id . '"');
            }
            $insert_order = true;
          }
        } else {
          $insert_order = true;
        }
        if ($insert_order == true) {
          $order_totals = array();
          if (is_array($order_total_modules->modules)) {
            reset($order_total_modules->modules);
            while (list(, $value) = each($order_total_modules->modules)) {
              $class = substr($value, 0, strrpos($value, '.'));
              if ($GLOBALS[$class]->enabled) {
                for ($i=0, $n=sizeof($GLOBALS[$class]->output); $i<$n; $i++) {
                  if (tep_not_null($GLOBALS[$class]->output[$i]['title']) && tep_not_null($GLOBALS[$class]->output[$i]['text'])) {
                    $order_totals[] = array('code' => $GLOBALS[$class]->code,
                                            'title' => $GLOBALS[$class]->output[$i]['title'],
                                            'text' => $GLOBALS[$class]->output[$i]['text'],
                                            'value' => $GLOBALS[$class]->output[$i]['value'],
                                            'sort_order' => $GLOBALS[$class]->sort_order);
                  }
                }
              }
            }
          }
          $sql_data_array = array('customers_id' => $customer_id,
                                  'customers_name' => $order->customer['firstname'] . ' ' . $order->customer['lastname'],
                                  'customers_company' => $order->customer['company'],
                                  'customers_street_address' => $order->customer['street_address'],
                                  'customers_suburb' => $order->customer['suburb'],
                                  'customers_city' => $order->customer['city'],
                                  'customers_postcode' => $order->customer['postcode'],
                                  'customers_state' => $order->customer['state'],
                                  'customers_country' => $order->customer['country']['title'],
                                  'customers_telephone' => $order->customer['telephone'],
                                  'customers_email_address' => $order->customer['email_address'],
                                  'customers_address_format_id' => $order->customer['format_id'],
                                  'delivery_name' => $order->delivery['firstname'] . ' ' . $order->delivery['lastname'],
                                  'delivery_company' => $order->delivery['company'],
                                  'delivery_street_address' => $order->delivery['street_address'],
                                  'delivery_suburb' => $order->delivery['suburb'],
                                  'delivery_city' => $order->delivery['city'],
                                  'delivery_postcode' => $order->delivery['postcode'],
                                  'delivery_state' => $order->delivery['state'],
                                  'delivery_country' => $order->delivery['country']['title'],
                                  'delivery_address_format_id' => $order->delivery['format_id'],
                                  'billing_name' => $order->billing['firstname'] . ' ' . $order->billing['lastname'],
                                  'billing_company' => $order->billing['company'],
                                  'billing_street_address' => $order->billing['street_address'],
                                  'billing_suburb' => $order->billing['suburb'],
                                  'billing_city' => $order->billing['city'],
                                  'billing_postcode' => $order->billing['postcode'],
                                  'billing_state' => $order->billing['state'],
                                  'billing_country' => $order->billing['country']['title'],
                                  'billing_address_format_id' => $order->billing['format_id'],
                                  'payment_method' => $order->info['payment_method'],
                                  'cc_type' => $order->info['cc_type'],
                                  'cc_owner' => $order->info['cc_owner'],
                                  'cc_number' => $order->info['cc_number'],
                                  'cc_expires' => $order->info['cc_expires'],
                                  'date_purchased' => 'now()',
                                  'orders_status' => $order->info['order_status'],
                                  'currency' => $order->info['currency'],
                                  'currency_value' => $order->info['currency_value']);
          tep_db_perform(TABLE_ORDERS, $sql_data_array);
          $insert_id = tep_db_insert_id();
          for ($i=0, $n=sizeof($order_totals); $i<$n; $i++) {
            $sql_data_array = array('orders_id' => $insert_id,
                                    'title' => $order_totals[$i]['title'],
                                    'text' => $order_totals[$i]['text'],
                                    'value' => $order_totals[$i]['value'],
                                    'class' => $order_totals[$i]['code'],
                                    'sort_order' => $order_totals[$i]['sort_order']);
            tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
          }
          for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
            $sql_data_array = array('orders_id' => $insert_id,
                                    'products_id' => tep_get_prid($order->products[$i]['id']),
                                    'products_model' => $order->products[$i]['model'],
                                    'products_name' => $order->products[$i]['name'],
                                    'products_price' => $order->products[$i]['price'],
                                    'final_price' => $order->products[$i]['final_price'],
                                    'products_tax' => $order->products[$i]['tax'],
                                    'products_quantity' => $order->products[$i]['qty'],
									'orders_products_image' => $order->products[$i]['image'],
									'orders_products_image2' => $order->products[$i]['image2']);






            tep_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
            $order_products_id = tep_db_insert_id();
            $attributes_exist = '0';
            if (isset($order->products[$i]['attributes'])) {
              $attributes_exist = '1';
              for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
                if (DOWNLOAD_ENABLED == 'true') {
                  $attributes_query = "select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix, pad.products_attributes_maxdays, pad.products_attributes_maxcount , pad.products_attributes_filename
                                       from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                       left join " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                                       on pa.products_attributes_id=pad.products_attributes_id
                                       where pa.products_id = '" . $order->products[$i]['id'] . "'
                                       and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "'
                                       and pa.options_id = popt.products_options_id
                                       and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "'
                                       and pa.options_values_id = poval.products_options_values_id
                                       and popt.language_id = '" . $languages_id . "'
                                       and poval.language_id = '" . $languages_id . "'";
                  $attributes = tep_db_query($attributes_query);
                } else {
                  $attributes = tep_db_query("select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa where pa.products_id = '" . $order->products[$i]['id'] . "' and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "' and pa.options_id = popt.products_options_id and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "' and pa.options_values_id = poval.products_options_values_id and popt.language_id = '" . $languages_id . "' and poval.language_id = '" . $languages_id . "'");
                }
                $attributes_values = tep_db_fetch_array($attributes);
                $sql_data_array = array('orders_id' => $insert_id,
                                        'orders_products_id' => $order_products_id,
                                        'products_options' => $attributes_values['products_options_name'],
                                        'products_options_values' => $attributes_values['products_options_values_name'],
                                        'options_values_price' => $attributes_values['options_values_price'],
                                        'price_prefix' => $attributes_values['price_prefix']);
                tep_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array);
                if ((DOWNLOAD_ENABLED == 'true') && isset($attributes_values['products_attributes_filename']) && tep_not_null($attributes_values['products_attributes_filename'])) {
                  $sql_data_array = array('orders_id' => $insert_id,
                                          'orders_products_id' => $order_products_id,
                                          'orders_products_filename' => $attributes_values['products_attributes_filename'],
                                          'download_maxdays' => $attributes_values['products_attributes_maxdays'],
                                          'download_count' => $attributes_values['products_attributes_maxcount']);
                  tep_db_perform(TABLE_ORDERS_PRODUCTS_DOWNLOAD, $sql_data_array);
                }
              }
            }
          }
          $cart_pagseguro_ID = $cartID . '-' . $insert_id;
          tep_session_register('cart_pagseguro_ID');
        }
      }
      return $confirmation;
    }
    function get_uf(){
       global $order;
        $res = tep_db_fetch_array($qry=tep_db_query('select countries_id from '.TABLE_COUNTRIES.' where countries_name="Brazil" or countries_name="Brasil"'));
        $br_id = $res['countries_id']; // código do Brasil. em caso da loja ter usado outro código interno.
        $res = tep_db_fetch_array($qry=tep_db_query('select zone_code from '.TABLE_ZONES.' where zone_country_id="'.$br_id.'" and zone_name="'.$order->delivery['state'].'"'));
        return $res['zone_code'];
    }
    function process_button() {
      global $HTTP_POST_VARS, $order, $cart, $currencies, $cartID, $cart_pagseguro_ID, $insert_id, $customer_id;
	  $currency = MODULE_PAYMENT_PAGSEGURO_CURRENCY; // Somente reais
      // removes non numeric characters from the telephone field, and trims to 8 chars long.
      $cust_telephone = eregi_replace ("[^0-9]", "", $order->customer['telephone']);
	  $cust_telephone2 = eregi_replace ("[^0-9]", "", $order->customer['telephone']);
      $st = strlen($cust_telephone)-8;
      if ($st>0) { // in case this string is longer than 8 characters (PagSeguro's settings)
          $cust_telephone = substr($cust_telephone, $st, 8);
		  $cust_ddd = substr($cust_telephone2, 0, 2);
		  $cust_num = "s/n";
		  $cust_compl = " ";
      }
      $UF = $this->get_uf();
      $CEP = substr(eregi_replace ("[^0-9]", "", $order->customer['postcode']).'00000000',0,8);
	  $insert_id = substr($cart_pagseguro_ID, strpos($cart_pagseguro_ID, '-')+1);
      $process_button_string = tep_draw_hidden_field('email_cobranca', MODULE_PAYMENT_PAGSEGURO_EMAIL) . "\n" .// email de cobrança, definido no admin
                               tep_draw_hidden_field('tipo', 'CP') . "\n" .  // Carrinho prório
                               tep_draw_hidden_field('moeda', 'BR') . "\n" .// Somente Reais - Substituí BRL por BR (Sergio)
                               tep_draw_hidden_field('cliente_nome', $order->customer['firstname']. " " . $order->customer['lastname']) . "\n" .
                               tep_draw_hidden_field('cliente_cep', $CEP) . "\n" .
                               tep_draw_hidden_field('cliente_end', $order->delivery['street_address']) . "\n" .
                               tep_draw_hidden_field('cliente_bairro', $order->delivery['suburb']) . "\n" .
                               tep_draw_hidden_field('cliente_cidade', $order->delivery['city']) . "\n" .
                               tep_draw_hidden_field('cliente_uf', $UF) . "\n" .
                               tep_draw_hidden_field('cliente_pais', 'BRA') . "\n" .
							   tep_draw_hidden_field('cliente_ddd', $cust_ddd) . "\n" .
                               tep_draw_hidden_field('cliente_tel', $cust_telephone) . "\n" .
							   tep_draw_hidden_field('cliente_num', $cust_num) . "\n" .
							   tep_draw_hidden_field('cliente_compl', $cust_compl) . "\n" .
							   					                               tep_draw_hidden_field('cliente_email', $order->customer['email_address'])."\n";
      $order_subtotal = 0; // calcula o somatório dos valores dos produtos
      for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
          $process_button_string .= tep_draw_hidden_field('item_id_'.($i+1),    $order->products[$i]['id']) . "\n" .
		                            tep_draw_hidden_field('item_descr_'.($i+1), $order->products[$i]['name'].(strlen($order->products[$i]['model'])>0?'['.$order->products[$i]['model'].']':'')) ."\n" .
		                            tep_draw_hidden_field('item_quant_'.($i+1), $order->products[$i]['qty']) ."\n" .
		                            tep_draw_hidden_field('item_valor_'.($i+1), round($order->products[$i]['final_price']* $currencies->get_value($currency)*100))."\n";
          $order_subtotal += $order->products[$i]['qty'] * $order->products[$i]['final_price']* $currencies->get_value($currency)*100;
       	  if (MODULE_PAYMENT_PAGSEGURO_SHIPPING=='True') {
              $process_button_string .= tep_draw_hidden_field('item_peso_'.($i+1),    (int)($order->products[$i]['weight']*(MODULE_PAYMENT_PAGSEGURO_WEIGHT=='Kg'?1000:1))) . "\n";
       	  }
	  }
	  // campo para informar os descontos / acréscimos extras do pedido
	      $retificacao = ($order->info['total'] - $order->info['shipping_cost'])* $currencies->get_value($currency)*100- $order_subtotal ;
	      if ((int)$retificacao!=0) {
              $process_button_string .= tep_draw_hidden_field('extras', floor($retificacao))."\n";
	      }
      //
	  if (MODULE_PAYMENT_PAGSEGURO_SHIPPING=='True') {
         $process_button_string .= "\n".tep_draw_hidden_field('tipo_frete', $_POST['TipoFrete']) ."\n"; // EN: encomenda normal; SD: Sedex
	  } else {
         $process_button_string .= "\n".tep_draw_hidden_field('item_frete_1', round($order->info['shipping_cost']* $currencies->get_value($currency)*100)) ."\n";
      }
      $process_button_string .= tep_draw_hidden_field('ref_transacao', 'Pedido: '.$insert_id.' - Cliente: '.$customer_id);
          if (tep_session_is_registered('INSERT_ID')) {
               tep_session_unregister('INSERT_ID');
          }
      return $process_button_string;
    }
    function before_process() {
	// chamado pelo checkout_process.php depois que a transaçào foi finalizada
      global $HTTP_POST_VARS, $HTTP_GET_VARS, $order, $cart, $sendto, $billto, $currencies, $insert_id;
        if (isset($_SESSION['cart_pagseguro_ID'])) {
           $tmp = explode('-', $_SESSION['cart_pagseguro_ID']);
           $insert_id = $tmp[1];
        } else $insert_id = $INSERT_ID;
        $qry = tep_db_query ($txt="select * from temp_pagseguro where referencia like 'PEDIDO: $insert_id - CLIENTE: %'");
		$order_array = tep_db_fetch_array($qry);
		$status = trim($order_array['statustransacao']);
        $ids = explode('-',$order_array['referencia']);
		$tmp = explode(':',$ids[0]);
$this->debug_var ($order_array, "Pedido(recuperado do bd): ".$txt.' '. date("Y-m-d G:i:s"),true);
$this->debug_var ($status, "Status de pagamento: ".date("Y-m-d G:i:s"),true);
        $customer = explode(':',$ids[1]);
        $customer_id = trim($customer[1]);
		switch($status){
		    case 'Completo':
		    case 'Aprovado':
                    $order->info['order_status'] = MODULE_PAYMENT_PAGSEGURO_APPROVED_ORDER_STATUS_ID;
$this->debug_var ($order->info['order_status'], "pagamento aprovado: ".date("Y-m-d G:i:s"),true);
		    case 'Em Análise':
		    case 'Aguardando Pagto':
            		$order->info['comments'] .= "ID de Transação: ". $order_array['transacaoid'].
					                            "\nAnotação: ". $order_array['anotacao'].
            		                            "\nTipo do Pagamento: ". $order_array['tipopagamento'].
            									"\nStatus: ". $status;
                    include(DIR_WS_CLASSES . 'order_total.php');
                    $order_total_modules = new order_total;
                    $order_totals = $order_total_modules->process();
                    $order_id = $insert_id;
                    $sql_data_array = array('orders_id' => $order_id,
                                            'orders_status_id' => $order->info['order_status'],
                                            'date_added' => 'now()',
                                            'customer_notified' => (SEND_EMAILS == 'true') ? '1' : '0',
                                            'comments' => $order->info['comments']);
                    tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
                    // update orders table
                    $sql_data_array = array('orders_status' => $order->info['order_status']);
                    tep_db_perform(TABLE_ORDERS, $sql_data_array, 'update', "orders_id = '" . (int)$order_id . "'");
            // initialized for the email confirmation
                  $products_ordered = '';
                  $subtotal = 0;
                  $total_tax = 0;
                  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
            // Stock Update - Joao Correia
                    if (STOCK_LIMITED == 'true') {
                      if (DOWNLOAD_ENABLED == 'true') {
                        $stock_query_raw = "SELECT products_quantity, pad.products_attributes_filename
                                            FROM " . TABLE_PRODUCTS . " p
                                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                            ON p.products_id=pa.products_id
                                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                                            ON pa.products_attributes_id=pad.products_attributes_id
                                            WHERE p.products_id = '" . tep_get_prid($order->products[$i]['id']) . "'";
            // Will work with only one option for downloadable products
            // otherwise, we have to build the query dynamically with a loop
                        $products_attributes = $order->products[$i]['attributes'];
                        if (is_array($products_attributes)) {
                          $stock_query_raw .= " AND pa.options_id = '" . $products_attributes[0]['option_id'] . "' AND pa.options_values_id = '" . $products_attributes[0]['value_id'] . "'";
                        }
                        $stock_query = tep_db_query($stock_query_raw);
                      } else {
                        $stock_query = tep_db_query("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
                      }
                      if (tep_db_num_rows($stock_query) > 0) {
                        $stock_values = tep_db_fetch_array($stock_query);
            // do not decrement quantities if products_attributes_filename exists
                        if ((DOWNLOAD_ENABLED != 'true') || (!$stock_values['products_attributes_filename'])) {
                          $stock_left = $stock_values['products_quantity'] - $order->products[$i]['qty'];
                        } else {
                          $stock_left = $stock_values['products_quantity'];
                        }
                        tep_db_query("update " . TABLE_PRODUCTS . " set products_quantity = '" . $stock_left . "' where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
                        if ( ($stock_left < 1) && (STOCK_ALLOW_CHECKOUT == 'false') ) {
                          tep_db_query("update " . TABLE_PRODUCTS . " set products_status = '0' where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
                        }
                      }
                    }
            // Update products_ordered (for bestsellers list)
                    tep_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $order->products[$i]['qty']) . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
            //------insert customer choosen option to order--------
                    $attributes_exist = '0';
                    $products_ordered_attributes = '';
                    if (isset($order->products[$i]['attributes'])) {
                      $attributes_exist = '1';
                      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
                        if (DOWNLOAD_ENABLED == 'true') {
                          $attributes_query = "select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix, pad.products_attributes_maxdays, pad.products_attributes_maxcount , pad.products_attributes_filename
                                               from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                               left join " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                                               on pa.products_attributes_id=pad.products_attributes_id
                                               where pa.products_id = '" . $order->products[$i]['id'] . "'
                                               and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "'
                                               and pa.options_id = popt.products_options_id
                                               and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "'
                                               and pa.options_values_id = poval.products_options_values_id
                                               and popt.language_id = '" . $languages_id . "'
                                               and poval.language_id = '" . $languages_id . "'";
                          $attributes = tep_db_query($attributes_query);
                        } else {
                          $attributes = tep_db_query("select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa where pa.products_id = '" . $order->products[$i]['id'] . "' and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "' and pa.options_id = popt.products_options_id and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "' and pa.options_values_id = poval.products_options_values_id and popt.language_id = '" . $languages_id . "' and poval.language_id = '" . $languages_id . "'");
                        }
                        $attributes_values = tep_db_fetch_array($attributes);
                        $products_ordered_attributes .= "\n\t" . $attributes_values['products_options_name'] . ' ' . $attributes_values['products_options_values_name'];
                      }
                    }
            //------insert customer choosen option eof ----
                    $total_weight += ($order->products[$i]['qty'] * $order->products[$i]['weight']);
                    $total_tax    += tep_calculate_tax($total_products_price, $products_tax) * $order->products[$i]['qty'];
                    $total_cost   += $total_products_price;
                    $products_ordered .= $order->products[$i]['qty'] . ' x ' . $order->products[$i]['name'] . ' (' . $order->products[$i]['model'] . ') = ' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) . $products_ordered_attributes . "\n";
                  }
            // lets start with the email confirmation
                  $email_order = STORE_NAME . "\n" .
                                 EMAIL_SEPARATOR . "\n" .
                                 EMAIL_TEXT_ORDER_NUMBER . ' ' . $order_id . "\n" .
                                 EMAIL_TEXT_INVOICE_URL . ' ' . tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $order_id, 'SSL', false) . "\n" .
                                 EMAIL_TEXT_DATE_ORDERED . ' ' . strftime(DATE_FORMAT_LONG) . "\n\n";
                  if ($order->info['comments']) {
                    $email_order .= tep_db_output($order->info['comments']) . "\n\n";
                  }
                  $email_order .= EMAIL_TEXT_PRODUCTS . "\n" .
                                  EMAIL_SEPARATOR . "\n" .
                                  $products_ordered .
                                  EMAIL_SEPARATOR . "\n";
                  for ($i=0, $n=sizeof($order_totals); $i<$n; $i++) {
                    $email_order .= strip_tags($order_totals[$i]['title']) . ' ' . strip_tags($order_totals[$i]['text']) . "\n";
                  }
                  if ($order->content_type != 'virtual') {
                    $email_order .= "\n" . EMAIL_TEXT_DELIVERY_ADDRESS . "\n" .
                                    EMAIL_SEPARATOR . "\n" .
                                    tep_address_label($customer_id, $sendto, 0, '', "\n") . "\n";
                  }
                  $email_order .= "\n" . EMAIL_TEXT_BILLING_ADDRESS . "\n" .
                                  EMAIL_SEPARATOR . "\n" .
                                  tep_address_label($customer_id, $billto, 0, '', "\n") . "\n\n";
                  if (is_object($$payment)) {
                    $email_order .= EMAIL_TEXT_PAYMENT_METHOD . "\n" .
                                    EMAIL_SEPARATOR . "\n".
            						EMAIL_TEXT_PAGSEGURO_WAIT. "\n";
                    $payment_class = $$payment;
                    $email_order .= $payment_class->title . "\n\n";
                    if ($payment_class->email_footer) {
                      $email_order .= $payment_class->email_footer . "\n\n";
                    }
                  }
                  tep_mail($order->customer['firstname'] . ' ' . $order->customer['lastname'], $order->customer['email_address'], EMAIL_TEXT_SUBJECT, $email_order, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
            // send emails to other people
                  if (SEND_EXTRA_ORDER_EMAILS_TO != '') {
                    tep_mail('', SEND_EXTRA_ORDER_EMAILS_TO, EMAIL_TEXT_SUBJECT, $email_order, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
                  }
            // load the after_process function from the payment modules
                  $this->after_process();
                  $cart->reset(true);
            // unregister session variables used during checkout
                  tep_session_unregister('sendto');
                  tep_session_unregister('billto');
                  tep_session_unregister('shipping');
                  tep_session_unregister('payment');
                  tep_session_unregister('comments');
                  tep_session_unregister('cart_pagseguro_ID');
                  tep_redirect(tep_href_link(FILENAME_CHECKOUT_SUCCESS, '', 'SSL'));
            	  return false;
                break;
		    default:
                  $email_order = 'Pedido feito no '. STORE_NAME . "\n" .
                                 'Cliente: '. $order->customer['firstname'] . ' ' . $order->customer['lastname']. "\n" .
                                 EMAIL_SEPARATOR . "\n" .
                                 'Status do pagamento: '. $status . "\n" .
                                 EMAIL_TEXT_ORDER_NUMBER . ' ' . $order_id . "\n" .
                                 EMAIL_TEXT_DATE_ORDERED . ' ' . strftime(DATE_FORMAT_LONG) . "\n\n".
                                 print_r($_SESSION,true);
                  tep_mail(	STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS, 'Pedido efetuado e pago no PagSeguro - email enviado para verificação do funcionamento', $email_order, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
$this->debug_var ($email_order, "email de suporte: ".date("Y-m-d G:i:s"),true);
      		    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error='.$this->code.'&error='.urlencode('Ocorreu algum erro de comunicação com o servidor. Verifique se seu pagamento foi processado e entre em contato com a administração.'),'NONSSL', true, false));
		} // switch
		exit();
    }
    function after_process() {
      return false;
    }
    function get_error() {
		global $language;
		$error_text['title']='Erro:';
		$error_text['error']=urldecode($_GET['error']);
      return $error_text;
    }
    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_PAGSEGURO_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }
    function install() {
	  $sort_order = 1;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "set_function, date_added) values ('Aprovacao de Pagamento - PagSeguro', 'MODULE_PAYMENT_PAGSEGURO_STATUS', 'True', ".
                   "'Voce deseja aprovar compras utilizando o pagseguro?', '6', '".$sort_order."', ".
                   "'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "date_added".
                   ") values (".
                   "'Email no PagSeguro', 'MODULE_PAYMENT_PAGSEGURO_EMAIL', 'seu@email.com', ".
                   "'Informar o email de cobrança registrado junto à PagSeguro.', '6', '".$sort_order."', ".
                   "now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "date_added".
                   ") values (".
                   "'Token', 'MODULE_PAYMENT_PAGSEGURO_TOKEN', '0', ".
                   "'Código de segurança gerado manualmente no website do PagSeguro.', '6', '".$sort_order."', ".
                   "now())");
	  $sort_order++;  // Seleciona o código para a moeda padrão (em julho/2006 é Real, código = BRL, BR, etc)
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "date_added".
                   ") values (".
                   "'Moeda padrão', 'MODULE_PAYMENT_PAGSEGURO_CURRENCY', 'BR', ".
                   "'Código da moeda usado em seu site para o Real. Por ex.: BR, BRL, etc.', '6', '".$sort_order."', ".
                   "now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "set_function, date_added) values ('Unidade de peso', 'MODULE_PAYMENT_PAGSEGURO_WEIGHT', 'KG', ".
                   "'Você deseja calcular o frete em KG ou gramas?', '6', '".$sort_order."', ".
                   "'tep_cfg_select_option(array(\'Kg\', \'gramas\'), ', now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "set_function, date_added) values ('Cálculo do frete pelo PagSeguro?', 'MODULE_PAYMENT_PAGSEGURO_SHIPPING', 'True', ".
                   "'Você deseja calcular o frete através do site do PagSeguro?', '6', '".$sort_order."', ".
                   "'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "set_function, date_added)
                   values ('Aceita cartão?', 'MODULE_PAYMENT_PAGSEGURO_CREDIT_CARD', 'False', ".
                   "'Sua conta está configurada para aceitar cartões de crédito?', '6', '".$sort_order."', ".
                   "'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
	  $sort_order++;
/*
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "date_added".
                   ") values (".
                   "'Valor adicional 1', 'MODULE_PAYMENT_PAGSEGURO_ABSOLUTE', '', ".
                   "'Valor absoluto a ser acrescentado no total do pedido.', '6', '".$sort_order."', ".
                   "now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "date_added".
                   ") values (".
                   "'Valor adicional 2', 'MODULE_PAYMENT_PAGSEGURO_PERCENT', '', ".
                   "'Valor percentual a acrescentar ao valor total do pedido.', '6', '".$sort_order."', ".
                   "now())");
	  $sort_order++;
*/
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "use_function, set_function, date_added".
                   ") values (".
                   "'Zonas suportadas', 'MODULE_PAYMENT_PAGSEGURO_ZONE', '0', ".
                   "'Se uma zona for selecionada, este meio de pagamento estará disponível somente para esta zona.', '6', '".$sort_order."', ".
                   "'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "use_function, set_function, date_added".
                   ") values (".
                   "'Status dos pedidos', 'MODULE_PAYMENT_PAGSEGURO_ORDER_STATUS_ID', '2', ".
                   "'Atualiza o status dos pedidos efetuados por este módulo de pagamento para este valor.', '6', '".$sort_order."', ".
                   "'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses(', now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "use_function, set_function, date_added".
                   ") values (".
                   "'Pedidos aprovados', 'MODULE_PAYMENT_PAGSEGURO_APPROVED_ORDER_STATUS_ID', '2', ".
                   "'Atualiza o status dos pedidos aprovados por este módulo de pagamento para este valor.', '6', '".$sort_order."', ".
                   "'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses(', now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "set_function, date_added)".
                   "values ('Debug log', 'MODULE_PAYMENT_PAGSEGURO_DEBUG_LOG', 'False', ".
                   "'O módulo deve criar um log de debug na pasta EXT? Em caso afirmativo, dê permissão de escrita à pasta EXT. o arquivo debug.log conterá informações sobre a comunicação entre os servidores.', '6', '".$sort_order."', ".
                   "'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION .
                   " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
              values ('Email de debug', 'MODULE_PAYMENT_PAGSEGURO_DEBUG_EMAIL', '',
                      'Todos os parâmetros de uma notificação inválida serão enviados para este endereço de email se estiver presente.', '6', $sort_order, now())");
	  $sort_order++;
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "date_added".
                   ") values (".
                   "'Ordem de exibição', 'MODULE_PAYMENT_PAGSEGURO_SORT_ORDER', '0', ".
                   "'Determina a ordem de exibição do meio de pagamento.', '6', '".$sort_order."', ".
                   "now())");
      tep_db_query("CREATE TABLE temp_pagseguro (
                        id INT( 13 ) NOT NULL AUTO_INCREMENT ,
                        vendedoremail VARCHAR( 200 ) NOT NULL ,
                        transacaoid VARCHAR( 40 ) NOT NULL ,
                        referencia VARCHAR( 128 ) NOT NULL ,
                        anotacao TEXT ,
                        datatransacao DATE NOT NULL ,
                        tipopagamento VARCHAR( 32 ) NOT NULL ,
                        statustransacao VARCHAR( 32 ) NOT NULL ,
                        clinome VARCHAR( 128 ) NOT NULL ,
                        cliemail VARCHAR( 128 ) NOT NULL ,
                        date_created datetime ,
                        PRIMARY KEY ( id ));"
                  );
    }
    function remove() {
       tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
       tep_db_query("drop table temp_pagseguro");
    }
    function keys() {
		$key_listing = array();
		$qry = "select configuration_key from " . TABLE_CONFIGURATION . " where LOCATE('MODULE_PAYMENT_PAGSEGURO', configuration_key)>0 order by sort_order";
		$findkey = tep_db_query($qry);
		while($key = tep_db_fetch_array($findkey)){
			$key_listing[] = $key['configuration_key'];
		} // while
      return $key_listing;
    }
      function debug_var($var, $name="", $to_file=false){
        if ($to_file) {
            if (MODULE_PAYMENT_PAGSEGURO_DEBUG_LOG=='True') {
                if ($txt = @fopen('ext/debug.log','a')) {
                    fwrite($txt, "-----------------------------------\n");
                    fwrite($txt, $name."\n");
                    fwrite($txt,  print_r($var, true)."\n");
                    fclose($txt);//
                }
            }
        } else {
             print('<br><b>'.$name.'</b><br>');
             echo '<pre>';
        	 print_r($var);
        	 echo '</pre>';
        }
      }
  }
?>
