<?php

/*
  Title: Crex (osCommeRcE Xml)
  Purpose: XML library for oSC based installations
  Author: Red Pier Systems (aka Yafide on Sourceforge.net)   (Red Pier Systems copyrights 2007)
  Date: April 1 2007
  Version: 0.0.1
  Notes: This library creates a means to access data from an osCommerce cart's database in an XML format.
  Requires: Usually, any osCommerce install that contains the scripts listed in the $includes_search variable.
  License: GPL. Please view GPL License file "readme-license-gpl.txt" distributed with this file release. If
  you did not receive a copy of this license, you may download the entire file release from:
         
          http://sourceforge.net/projects/crex
*/

//NOTE: These functions are here to provide XML funcitonality to osCommerce based sites.
      //---------------- BASIC FUNCTIONS -----------------
      //Retrieves the GET/POST variable in a sanitized manner.
      function crex_request($var, $quote_mode = ENT_QUOTES){
         if ($_REQUEST[$var]){
            return htmlentities($_REQUEST[$var], $quote_mode);
         }
         return '';
      }
      

      function crex_xml_cdata($string=''){
        //FUNCTION: Returns data encapsulated in a CDATA tag.

        if ($string){
          return '<![CDATA['.htmlentities($string, ENT_QUOTES).']]>';
        } else {
          return '';
        }
      }
      function crex_xml_data_node($string='', $args = array(''=>'')){
        //FUNCTION: Returns data encapsulated ina DATA tag.
        return '<data'.crex_node_attributes_from_array($args).'>'.$string.'</data>';
      }
      function crex_xml_root_node($string='', $args = array(''=>'')){
        //FUNCTION: Returns data encapsulated in a ROOT tag.
        return '<root'.crex_node_attributes_from_array($args).'>'.$string.'</root>';
      }
      function crex_node_attributes_from_array($array=array(''=>'')){
        //FUNCTION: Creates a string containing a node's attributes.
        $tag_attributes = '';
        foreach($array as $key=>$value){
          if ($key && $key!="name"){
          $tag_attributes .= $key.'="'.$value.'" ';
          }
        }
        //If we received attributes, prepend 1 spacing.
        if ($tag_attributes) $tag_attributes = ' '.$tag_attributes;
        return $tag_attributes;
      }
      function crex_xml_from_array($array){
        //FUNCTION: Read each value in ASSOCIATIVE array, and convert into XML string. Return XML String.
        $return_value = '';
        foreach ($array as $key => $value){
                $return_value .= '<'.$key.'>'.crex_xml_cdata($value).'</'.$key.'>';
        }
        return $return_value;
      }
      
      //---------------  BASIC FUNCTIONS EOF -------------
      
      //--------------  MACRO FUNCTIONS ------------------
            
            // ~~~~~~~~~~~~~~~~~   WARNING  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            //WARNING: Never allow this function to be directly called upon by outside source.
            //Doing so allows the user to read *ANY* existing table in the database (if includes were found).
            //
            //This includes customer orders, users, and sensitive database info not meant for
            //unauthorized users to view.
            //
            //This function is used by the CREX php library to call certain tables, and retrieve their values.
      function crex_sql_query_to_xml_document($args=array('query'=>'')){
        //FUNCTION: run SQL query, return results as an XML document.
        if (function_exists('tep_db_query')){
           //Run SQL and process result
           if ($args['query']){

              $sql_result = tep_db_query($args['query']);

              $sql_array = array();
              $sql_error = mysql_error();
              $sql_row_count = 0;

              if (!$sql_error){
                //Create XML nodes of returned SQL rows.
                while ($row = tep_db_fetch_array($sql_result)){
                  $sql_array[$sql_row_count] = crex_xml_data_node(crex_xml_from_array($row), array('id'=>$sql_row_count, 'language_id'=>$args['language_id']));
                  $sql_row_count ++;
                }

                if ($sql_row_count > 0){
                  //If we have more than 0 rows returned, return the whole XML document of found rows.
                  $return_value = crex_xml_root_node(implode('', $sql_array));
                } else {
                  $return_value = crex_create_error_document('ERROR #4: No values returned.');
                }
              } else {
                $return_value = crex_create_error_document('ERROR #3: '.$sql_error.'.');
              }
              //;
           } else {
              $return_value = crex_create_error_document('ERROR #2: No query supplied.');
           }
        } else {
          //Return "osCommerce install not found" error.
          $return_value = crex_create_error_document('ERROR #1: osCommerce Install not found.');
        }
        return $return_value;
      }
            // ~~~~~~~~~~~~~~~~~  WARNING EOF  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      function crex_create_error_document($text){
        //FUNCTION: creates an XML document containing an Error description.
        $return_value = crex_xml_root_node(crex_xml_data_node(crex_xml_cdata($text), array('type'=>'error')));
        return $return_value;
      }
      function crex_create_error_data_document($text){
        //FUNCTION: creates an XML document containing an Error description.
        $return_value = crex_xml_root_node(crex_xml_data_node($text, array('type'=>'error')));
        return $return_value;
      }

      function crex_create_table_document($data = array(''=>'')){
        //TODO: create an XML document containing the table data

      }

      //--------------  MACRO FUNCTIONS EOF --------------
      // ------------- ADAPTED FUNCTIONS from osCommerce ------------------
      // NOTE: Most, if not all, of the ADAPTED FUNCTIONS listed herein are modified versions, or include parts of, the original osCommerce functions.

      //Adapted from osCommerce tep_get_category() function in the "/includes/boxes/categories.php" script
      function crex_get_categories_xml($args=array('language_id'=>'1')){
        global $tree, $categories_string, $cPath_array, $lang_id;

        $categories_string = '';
        $tree = array();
        $lang_id = $args['language_id'];
        $q = "select c.categories_id, cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.parent_id = '0' and c.categories_id = cd.categories_id and cd.language_id='" . (int)$args['language_id'] ."' order by sort_order, cd.categories_name";

        $categories_query = tep_db_query($q);


        while ($categories = tep_db_fetch_array($categories_query))  {
            $tree[$categories['categories_id']] = array('name' => $categories['categories_name'],
                                                        'parent' => $categories['parent_id'],
                                                        'level' => 0,
                                                        'path' => $categories['categories_id'],
                                                        'next_id' => false);
      
            if (isset($parent_id)) {
              $tree[$parent_id]['next_id'] = $categories['categories_id'];
            }
      
            $parent_id = $categories['categories_id'];
      
            if (!isset($first_element)) {
              $first_element = $categories['categories_id'];
            }
        }

        if (tep_not_null($cPath)) {
          $new_path = '';
          reset($cPath_array);
          while (list($key, $value) = each($cPath_array)) {
            unset($parent_id);
            unset($first_id);

            $categories_query = tep_db_query("select c.categories_id, cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.parent_id = '" . (int)$value . "' and c.categories_id = cd.categories_id and cd.language_id='" . (int)$args['language_id'] ."' order by sort_order, cd.categories_name");

            if (tep_db_num_rows($categories_query)) {
              $new_path .= $value;
              while ($row = tep_db_fetch_array($categories_query)) {
                $tree[$row['categories_id']] = array('name' => $row['categories_name'],
                                                     'parent' => $row['parent_id'],
                                                     'level' => $key+1,
                                                     'path' => $new_path . '_' . $row['categories_id'],
                                                     'next_id' => false);
          
                if (isset($parent_id)) {
                  $tree[$parent_id]['next_id'] = $row['categories_id'];
                }
          
                $parent_id = $row['categories_id'];
          
                if (!isset($first_id)) {
                  $first_id = $row['categories_id'];
                }
          
                $last_id = $row['categories_id'];
              }
              $tree[$last_id]['next_id'] = $tree[$value]['next_id'];
              $tree[$value]['next_id'] = $first_id;
              $new_path .= '_';
            } else {
              break;
            }
          }
        }
        
        $retval = crex_xml_root_node(crex_get_category_xml($first_element));

        return $retval;
      }
      
      
      
      
      
      
      function crex_append_category_limb($parent_id, $category_tree, $cid_blacklist, $result = NULL, $limb_depth = 0){
            if ($cid_blacklist == NULL) $cid_blacklist = Array();
            if ($result == NULL) $result = Array();
            $xml_output = '';
            
            $is_seo_enabled = 'false';
            if(defined('SEO_ENABLED')) {
                  if(SEO_ENABLED) $is_seo_enabled = 'true';
            }
            foreach($category_tree as $index => $category_node){
                  $category_parent_id = $category_node['parent_id'];
                  $category_id = $category_node['categories_id'];
                  $category_name = $category_node['categories_name'];
                  
                  if($category_parent_id || $category_parent_id === 0){
                                                
                        if(($category_parent_id === $parent_id) && !in_array($category_id, $cid_blacklist)){
                              
                              array_push($cid_blacklist, $category_id);
                              $node = Array();
                              
                              $node = $category_node;
                              $node['limb_depth'] = $limb_depth;
                              $product_count = tep_count_products_in_category($category_id);
                              $product_count_attribute = '';
                              if($product_count > 0) $product_count_attribute = ' product_count="'.$product_count.'"';
                              
                              if (tep_has_category_subcategories($category_node['categories_id'])){
                                    $limb_depth ++;
                                    $node['has_children'] = true;
                                    
                                    $limb = crex_append_category_limb($category_node['categories_id'], $category_tree, $cid_blacklist, NULL, $limb_depth);
                                    $node['subcategories'] = $limb['data'];
                                    
                                    $cid_blacklist = array_merge($cid_blacklist, $limb['blacklist']);
                                    $cid_blacklist = array_unique($cid_blacklist);
                                    $xml_output .= '<data seo="'.$is_seo_enabled.'" cpath="'.$category_id.'" has_subcategories="true" link="'.htmlentities(tep_href_link(FILENAME_DEFAULT, 'cPath='.$category_id),ENT_QUOTES).'" parent="'.$category_parent_id.'"'.$product_count_attribute.'>'.crex_xml_cdata($category_name).'</data>';
                                    $xml_output .= $limb['xml_string'];
                              } else {
                                    $node['has_children'] = 'false';
                                    $xml_output .= '<data seo="'.$is_seo_enabled.'" cpath="'.$category_id.'" has_subcategories="false" link="'.htmlentities(tep_href_link(FILENAME_DEFAULT, 'cPath='.$category_id),ENT_QUOTES).'" parent="'.$category_parent_id.'"'.$product_count_attribute.'>'.crex_xml_cdata($category_name).'</data>';
                              }
                              
                              
                              array_push($result, $node);
                        }
                  }
                  
            }
            

            return Array('blacklist'=>$cid_blacklist, 'data'=>$result, 'xml_string'=>$xml_output);
      }
      function crex_get_all_categories_xml($language_id, $starting_cid = NULL){
            // This function combs thru the list of retrieve categories
            // (they must be retrieved in ASCENDING order, ordered by parent_id
            // for this function to work) and inspects each categories_id.
            //
            // Every categories_id is checked (recursively) for sub categories.
            // Sub categories are appended as 'limbs' (a recursive list of its 
            // own sub categories)
            
            $query = "select c.categories_id, cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id='" . (int)$language_id ."' order by c.categories_id";
            
            $cid_blacklist = Array();
            $category_tree = Array();
            
            $categories_query = tep_db_query($query);
            
            $xml_output = '';
            
            $is_seo_enabled = 'false';
            if(defined('SEO_ENABLED')) {
                  if(SEO_ENABLED) $is_seo_enabled = 'true';
            }
            
            while ($categories = tep_db_fetch_array($categories_query))  {
                  array_push($category_tree, $categories);
            }
            $counter = 0;
            foreach($category_tree as $index => $category_item){

                  if(!in_array($category_item['categories_id'], $cid_blacklist) ){
                        array_push($cid_blacklist, $category_item['categories_id']);
                        
                        $tree[$counter] = $category_item;
                        $product_count = tep_count_products_in_category($category_item['categories_id']);
                        $product_count_attribute = '';
                        if($product_count > 0) $product_count_attribute = ' product_count="'.$product_count.'"';
                              
                        if (tep_has_category_subcategories($category_item['categories_id'])){
                              
                              $tree[$counter]['has_children'] = 'true';
                              $limb = crex_append_category_limb($category_item['categories_id'], $category_tree, $cid_blacklist);
                              $tree[$counter]['subcategories'] = $limb['data'];

                              $cid_blacklist = array_merge($cid_blacklist, $limb['blacklist']);
                              $cid_blacklist = array_unique($cid_blacklist);
                              $xml_output .= '<data seo="'.$is_seo_enabled.'" cpath="'.$category_item['categories_id'].'" has_subcategories="true" link="'.htmlentities(tep_href_link(FILENAME_DEFAULT, 'cPath='.$category_item['categories_id']),ENT_QUOTES).'" parent="'.$category_item['parent_id'].'"'.$product_count_attribute.'>'.crex_xml_cdata($category_item['categories_name']).'</data>';
                              $xml_output .= $limb['xml_string'];
                              
                        } else {
                              $tree[$counter]['has_children'] = 'false';
                              $xml_output .= '<data seo="'.$is_seo_enabled.'" cpath="'.$category_id.'" has_subcategories="false" link="'.htmlentities(tep_href_link(FILENAME_DEFAULT, 'cPath='.$category_item['categories_id']),ENT_QUOTES).'" parent="'.$category_item['parent_id'].'"'.$product_count_attribute.'>'.crex_xml_cdata($category_item['categories_name']).'</data>';
                        }
                        $counter++;
                  }
            }
            
            //DEBUG:
            return Array('tree'=>$tree, 'xml_string'=>crex_xml_root_node($xml_output));
        }
      
      
      
      
      
      
      
      
      
      //Recursive function used by "crex_get_categories_xml" to retrieve categories in the correct order.
      function crex_get_category_xml($counter) {
          global $tree, $categories_string, $cPath_array, $lang_id;

          $xml_node_data_is_current = '';
          $xml_node_data_product_count = '';
          $xml_node_data_has_sub_categories = '';
          //Is this node the current node?
          if (isset($cPath_array) && in_array($counter, $cPath_array)) {
            $xml_node_data_is_current = ' selected="true"';
          }
          //Does this category have sub categories?
          if (tep_has_category_subcategories($counter)) {
            $xml_node_data_has_sub_categories = ' has_subcategories="true"';
            

            $sql_subcat_result = tep_db_query("select c.categories_id, cd.categories_name, c.parent_id from ".TABLE_CATEGORIES." c, ".TABLE_CATEGORIES_DESCRIPTION." cd where c.parent_id = '".$counter."' and cd.categories_id = c.categories_id and cd.language_id='" . (int)$lang_id ."';");
            
            $is_seo_enabled = 'false';
            if(defined('SEO_ENABLED')) {
                  if(SEO_ENABLED) $is_seo_enabled = 'true';
            }
            
            while($arr_subcats = tep_db_fetch_array($sql_subcat_result)){
              //$xml_node_data_subcategories .= '{'.$arr_subcats['categories_id'].'}';
              //$xml_node_data_subcategories .= crex_get_category_xml($arr_subcats['categories_id']);
              $subcat_cpath = 'cPath='.$arr_subcats['categories_id'];
              
              $xml_node_data_subcategories .= '<data seo="'.$is_seo_enabled.'" cpath="'.$subcat_cpath.'" has_subcategories="check" link="'.htmlentities(tep_href_link(FILENAME_DEFAULT, $subcat_cpath),ENT_QUOTES).'" parent="'.$counter.'">'.$arr_subcats['categories_name'].'</data>';
            }

          }
          //If we need to know how many products are in this category, add it as an attribute.
          if (SHOW_COUNTS == 'true') {
            $products_in_category = tep_count_products_in_category($counter);
            if ($products_in_category > 0) {
              $xml_node_data_product_count = ' product_count="' . $products_in_category . '"';
            }
          }
          
          if ($tree[$counter]['parent'] == 0) {
            $cPath_new = 'cPath=' . $counter;
            $xml_cpath = ' cpath="'.$counter.'"';
            $cPath_link = ' link="'.htmlentities(tep_href_link(FILENAME_DEFAULT, $cPath_new), ENT_QUOTES).'" parent="'.$tree[$counter]['parent'].'"';
          } else {
            $cPath_new = 'cPath=' . $tree[$counter]['path'];
            $xml_cpath = ' cpath="'.$tree[$counter]['path'].'"';
            $cPath_link = ' link="'.htmlentities(tep_href_link(FILENAME_DEFAULT, $cPath_new), ENT_QUOTES).'" parent="'.$tree[$counter]['parent'].'"';
          }



          $xml_node_data = '<data seo="'.$is_seo_enabled.'"'.$xml_cpath.$xml_node_data_has_sub_categories.$cPath_link.$xml_node_cPath.$xml_node_data_is_current.$xml_node_data_product_count.'>';

          $xml_node_data .= '<![CDATA[';
          //Category Name
          $xml_node_data .= $tree[$counter]['name'];

          $xml_node_data .= ']]></data>'.$xml_node_data_subcategories;

          $categories_string .= $xml_node_data;

          if ($tree[$counter]['next_id'] != false) {
            return crex_get_category_xml($tree[$counter]['next_id']);
          } else {
            return $categories_string;
          }


        }
        
        
        //Gets all the products in the specified category
        function crex_get_category_products_xml($crex_cpath, $languages_id){
          $return_value = '';

          $result = tep_db_query("select distinct pc.products_id, pc.categories_id from ".TABLE_PRODUCTS_TO_CATEGORIES." pc, ".TABLE_PRODUCTS." p where pc.categories_id = '".$crex_cpath."'");


          $counter = 0;
          while($products_in_category = tep_db_fetch_array($result)){

            //Get the product's info
            $product_info_query = tep_db_query("select p.products_id,
                                                p.manufacturers_id from " . TABLE_PRODUCTS . " p,
                                                " . TABLE_PRODUCTS_DESCRIPTION . " pd
                                                where p.products_status = '1' and p.products_id = '" . $products_in_category['products_id'] . "' and
                                                pd.products_id = p.products_id and pd.language_id = '" . (int)$languages_id . "'");


            $product_info = tep_db_fetch_array($product_info_query);
            //add the product as xml to our return value...
            $return_value .= crex_xml_data_node(crex_xml_from_array($product_info));
            $counter ++;
          }

          //close our database connection, return result.

          return $return_value;
        }

        //Adapted from the product_info.php file in the root directory of the store.
        function crex_get_product_xml($crex_prod_id, $languages_id){
                 
                 //NOTE: checks to make sure we have more that 0 products available to display.
                 $query = "select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_status = '1' and p.products_id = '" . (int)$crex_prod_id . "' and pd.products_id = p.products_id and pd.language_id = '" . (int)$languages_id . "'";
                 $product_check_query = tep_db_query($query);
                 $product_check = tep_db_fetch_array($product_check_query);
                 
        
                 if ($product_check['total'] < 1) {
                   //No products found!
                   $crex_xml_output = crex_create_error_document('ERROR #A2: No products found. '.$query);
                 } else {
                   //Products found, retrieve the specified product.
                   $query = "select p.products_id, pd.products_name, pd.products_description, p.products_model, p.products_quantity, p.products_image, pd.products_url, p.products_price, p.products_tax_class_id, p.products_date_added, p.products_date_available, p.manufacturers_id from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_status = '1' and p.products_id = '" . (int)$crex_prod_id . "' and pd.products_id = p.products_id and pd.language_id = '" . (int)$languages_id . "'";
        
                   //TODO: osCommerce tracks how many times this product has been viewed. (simply uncomment)
                   //tep_db_query("update " . TABLE_PRODUCTS_DESCRIPTION . " set products_viewed = products_viewed+1 where products_id = '" . (int)$crex_prod_id . "' and language_id = '" . (int)$languages_id . "'");

                   return crex_sql_query_to_xml_document(array('query'=>$query));
        
                 }
        }
        
        //Adapted from the product_info.php file in the root directory of the store.
        function crex_get_product_attributes_xml($crex_prod_id, $languages_id){
        	$products_attributes_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_ATTRIBUTES . " patrib where patrib.products_id='" . $crex_prod_id . "' and patrib.options_id = popt.products_options_id and popt.language_id = '" . (int)$languages_id . "'");
			$products_attributes = tep_db_fetch_array($products_attributes_query);
			
			$output = '';
			
			if ($products_attributes['total'] > 0) {

			  $attrib_text =  TEXT_PRODUCT_OPTIONS;
			  
			  $products_options_name_query = tep_db_query("select distinct popt.products_options_id, popt.products_options_name from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_ATTRIBUTES . " patrib where patrib.products_id='" . $crex_prod_id . "' and patrib.options_id = popt.products_options_id and popt.language_id = '" . (int)$languages_id . "' order by popt.products_options_name");
			  while ($products_options_name = tep_db_fetch_array($products_options_name_query)) {
				$products_options_array = array();
				$products_options_query = tep_db_query("select pov.products_options_values_id, pov.products_options_values_name, pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_ATTRIBUTES . " pa, " . TABLE_PRODUCTS_OPTIONS_VALUES . " pov where pa.products_id = '" . $crex_prod_id . "' and pa.options_id = '" . (int)$products_options_name['products_options_id'] . "' and pa.options_values_id = pov.products_options_values_id and pov.language_id = '" . (int)$languages_id . "'");
				while ($products_options = tep_db_fetch_array($products_options_query)) {
				  $products_options_array[] = array('id' => $products_options['products_options_values_id'], 'text' => $products_options['products_options_values_name']);
				  if ($products_options['options_values_price'] != '0') {
					$products_options_array[sizeof($products_options_array)-1]['text'] .= ' (' . $products_options['price_prefix'] . $currencies->display_price($products_options['options_values_price'], tep_get_tax_rate($product_info['products_tax_class_id'])) .') ';
				  }
				}

				if (isset($cart->contents[$HTTP_GET_VARS['products_id']]['attributes'][$products_options_name['products_options_id']])) {
				  $selected_attribute = $cart->contents[$HTTP_GET_VARS['products_id']]['attributes'][$products_options_name['products_options_id']];
				} else {
				  $selected_attribute = false;
				}
				
				$attrib_name =  $products_options_name['products_options_name'];
				$attrib_options =  crex_create_option_list('id[' . $products_options_name['products_options_id'] . ']', $products_options_array, $selected_attribute);
				
				$output .= crex_xml_data_node( $attrib_options, Array('id'=>$attrib_name, 'options_text'=>$attrib_text) );
				
			  }
			  $output = crex_xml_root_node($output, Array('type'=>'error'));

			} else {
				$output = crex_xml_root_node(crex_xml_data_node( crex_xml_cdata('ERROR: No attributes found for product id '. $crex_prod_id .'.'), Array('type'=>'error') ));
			}
			
			return $output;

		}
		function crex_create_option_list($name, $values, $default = '') {
			

			if (empty($default) && isset($GLOBALS[$name])) $default = stripslashes($GLOBALS[$name]);

			for ($i=0, $n=sizeof($values); $i<$n; $i++) {
			  $field .= '<option value="' . tep_output_string($values[$i]['id']) . '"';
			  if ($default == $values[$i]['id']) {
				$field .= ' selected="true"';
			  }

			  $field .= '>' . crex_xml_cdata( tep_output_string($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) ) . '</option>';
			}

			return $field;
		}
      // ------------- ADAPTED FUNCTIONS from osCommerce EOF --------------

?>
