<?php
//session_start(); 
header('Content-Type: text/xml; charset=UTF-8');



/*
  Title: Crex - read.php (osCommeRcE Xml - read)
  Purpose: CREX output script. (example: product info, categories, products, etc..).
  Author: Red Pier Systems (aka Yafide on Sourceforge.net)   (Red Pier Systems copyrights 2007)
  Date: April 1 2007
  Version: 0.0.1
  Notes: This library creates a means to access data from an osCommerce cart in an XML format. This is the control panel page
  License: GPL. Please view GPL License file "readme-license-gpl.txt" distributed with this file release. If
  you did not receive a copy of this license, you may download the entire file release from:
         
          http://sourceforge.net/projects/crex
*/

//NOTE: Loop through list of includes. Include if found
      include('includes/application_top.php');
      include('includes/crex.php');


      $crex_xml_doctype = '<?xml version="1.0"?>';
      $crex_xml_output = '';


      //Get command.
      $crex_cmd = crex_request('cmd');
      //Get Language
      $languages_id = crex_request('language_id');
      if (!$languages_id) $languages_id = '1';
      //tep_db_connect();
      $languages_dir = tep_db_query("select `directory` from languages where `languages_id`='".$languages_id."';");

      $languages_dir = tep_db_fetch_array($languages_dir);
      //tep_db_close();
      $languages_dir = $languages_dir['directory'];

      switch($crex_cmd){
        case 'user_login':
              // NOTE: borrowed and slightly modified osCommerce code from login.php
              // USAGE: crex_read_pro.php?cmd=user_login&action=process&email_address=name@site.com&password=abcdef
              $error = false;
              if ($session_started == false) {
                $error = true;
                $variable_validation_errors_xml .= crex_xml_data_node("ERROR: COOKIES MUST BE ENABLED - ".FILENAME_COOKIE_USAGE, array('type'=>'login_error'));
              }
              
              //----- TODO: Implement Security Text or other Security Methods here -----
              //
              //------------------------------------------------------------------------

              if (($_SERVER["HTTPS"]=='on' || $_SERVER["HTTPS"]==1) || $_SERVER['SERVER_PORT'] == 443){
                include(DIR_WS_LANGUAGES . $language . '/' . FILENAME_LOGIN);

                if (isset($_REQUEST['action']) && ($_REQUEST['action'] == 'process')) {
                  $email_address = tep_db_prepare_input($_REQUEST['email_address']);
                  $password = tep_db_prepare_input($_REQUEST['password']);
  
               // Check if email exists
                  $check_customer_query = tep_db_query("select customers_id, customers_firstname, customers_password, customers_email_address, customers_default_address_id from " . TABLE_CUSTOMERS . " where customers_email_address = '" . tep_db_input($email_address) . "'");
                  if (!tep_db_num_rows($check_customer_query)) {
                    $error = true;
                    $variable_validation_errors_xml .= crex_xml_data_node("ERROR: Login failed. Please check your typing and try again.", array('type'=>'login_error', 'level'=>'1'));
                  } else {
                    $check_customer = tep_db_fetch_array($check_customer_query);
               // Check that password is good
                    if (!tep_validate_password($password, $check_customer['customers_password'])) {
                      $error = true;
                      $variable_validation_errors_xml .= crex_xml_data_node("ERROR: Login failed. Please check your typing and try again.", array('type'=>'login_error', 'level'=>'1'));
                    } else {
                      if (SESSION_RECREATE == 'True') {
                        tep_session_recreate();
                      }
  
                      $check_country_query = tep_db_query("select entry_country_id, entry_zone_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$check_customer['customers_id'] . "' and address_book_id = '" . (int)$check_customer['customers_default_address_id'] . "'");
                      $check_country = tep_db_fetch_array($check_country_query);
  
                      $customer_id = $check_customer['customers_id'];
                      $customer_default_address_id = $check_customer['customers_default_address_id'];
                      $customer_first_name = $check_customer['customers_firstname'];
                      $customer_country_id = $check_country['entry_country_id'];
                      $customer_zone_id = $check_country['entry_zone_id'];
                      tep_session_register('customer_id');
                      tep_session_register('customer_default_address_id');
                      tep_session_register('customer_first_name');
                      tep_session_register('customer_country_id');
                      tep_session_register('customer_zone_id');
  
                      tep_db_query("update " . TABLE_CUSTOMERS_INFO . " set customers_info_date_of_last_logon = now(), customers_info_number_of_logons = customers_info_number_of_logons+1 where customers_info_id = '" . (int)$customer_id . "'");
  
               // restore cart contents
                      $cart->restore_contents();
                      $success_href = '';
  
                      if (sizeof($navigation->snapshot) > 0) {
                        $origin_href = tep_href_link($navigation->snapshot['page'], tep_array_to_string($navigation->snapshot['get'], array(tep_session_name())), $navigation->snapshot['mode']);
                        $navigation->clear_snapshot();
                        $success_href = $origin_href;
                        //tep_redirect($origin_href);
                      } else {
                        //tep_redirect(tep_href_link(FILENAME_DEFAULT));
                        $success_href = FILENAME_DEFAULT;
                      }
                      $crex_xml_output = crex_xml_root_node( crex_xml_data_node(crex_xml_cdata($success_href), array('return'=>'true')) );
                    }
                  }
                } else {
                  //No variables supplied!
                  $error = true;
                  $variable_validation_errors_xml .= crex_xml_data_node("ERROR: Login failed. Please check your typing and try again.", array('type'=>'login_error', 'level'=>'1'));
                }
              //----------------
              } else {
                $error = true;
                $variable_validation_errors_xml .= crex_xml_data_node("ERROR: PLEASE USE HTTPS INSTEAD OF HTTP", array('type'=>'login_error'));
              }
              if ($error == true) {
                //$variable_validation_errors_xml .= crex_xml_data_node(ENTRY_STREET_ADDRESS_ERROR, array('type'=>'login_error'));
                $crex_xml_output = crex_create_error_data_document($variable_validation_errors_xml);
              }
            
              $breadcrumb->add(NAVBAR_TITLE, tep_href_link(FILENAME_LOGIN, '', 'SSL'));             
             break;
        case 'user_logout':
             //NOTE: Log user out. This is code borrowed from logoff.php
             //USAGE: crex_read_pro.php?cmd=user_logout

             include(DIR_WS_LANGUAGES . $language . '/' . FILENAME_LOGOFF);

             $breadcrumb->add(NAVBAR_TITLE);

             tep_session_unregister('customer_id');
             tep_session_unregister('customer_default_address_id');
             tep_session_unregister('customer_first_name');
             tep_session_unregister('customer_country_id');
             tep_session_unregister('customer_zone_id');
             tep_session_unregister('comments');

             $crex_xml_output = crex_xml_root_node( crex_xml_data_node(crex_xml_cdata('Log out ok.'), array('return'=>'true')) );

             $cart->reset();
             break;
        case 'user_get_info':
             //TODO: Connection needs to be https if available for this section.
             //TODO: retrieves shipping, billing, and order history for this user. add to server cookie.

             break;
        case 'user_register':
             //NOTE: uses GET vars to allow user registration thru any front end using XML.
             //      "country" value of 223 is "United States".

             //USAGE: crex_read_pro.php?cmd=user_register&action=process&gender=m&firstname=test&lastname=user&dob=01/01/1980&email_address=name@site.com&company=&street_address=111 Some St&suburb=&postcode=94555&city=Somecityname&state=CA&zone_id=&country=223&telephone=7075555555&fax=7075556677&newsletter=&password=abcdef&confirmation=abcdef

             //NOTE: Code borrowed from create_account.php (as a simple include() of that file causes html output to be 
             //mixed with the xml output...not good!)

             // needs to be included earlier to set the success message in the messageStack
             include(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CREATE_ACCOUNT);


             $variable_validation_errors_xml = '';

             // --------------------  User "create_account" routine BOF ---------------
             $process = false;

              if (isset($_REQUEST['action']) && ($_REQUEST['action'] == 'process')) {
                $process = true;
                // gender=m or gender=f (m = male, f = female)
                if (ACCOUNT_GENDER == 'true') {
                  if (isset($_REQUEST['gender'])) {
                    $gender = tep_db_prepare_input($_REQUEST['gender']);
                  } else {
                    $gender = false;
                  }
                }

                $firstname = tep_db_prepare_input($_REQUEST['firstname']);
                $lastname = tep_db_prepare_input($_REQUEST['lastname']);
                if (ACCOUNT_DOB == 'true') $dob = tep_db_prepare_input($_REQUEST['dob']);
                $email_address = tep_db_prepare_input($_REQUEST['email_address']);
                if (ACCOUNT_COMPANY == 'true') $company = tep_db_prepare_input($_REQUEST['company']);
                $street_address = tep_db_prepare_input($_REQUEST['street_address']);
                if (ACCOUNT_SUBURB == 'true') $suburb = tep_db_prepare_input($_REQUEST['suburb']);
                $postcode = tep_db_prepare_input($_REQUEST['postcode']);
                $city = tep_db_prepare_input($_REQUEST['city']);
                if (ACCOUNT_STATE == 'true') {
                  $state = tep_db_prepare_input($_REQUEST['state']);
                  if (isset($_REQUEST['zone_id'])) {
                    $zone_id = tep_db_prepare_input($_REQUEST['zone_id']);
                  } else {
                    $zone_id = false;
                  }
                }
                $country = tep_db_prepare_input($_REQUEST['country']);
                $telephone = tep_db_prepare_input($_REQUEST['telephone']);
                $fax = tep_db_prepare_input($_REQUEST['fax']);
                if (isset($_REQUEST['newsletter'])) {
                  $newsletter = tep_db_prepare_input($_REQUEST['newsletter']);
                } else {
                  $newsletter = false;
                }
                $password = tep_db_prepare_input($_REQUEST['password']);
                $confirmation = tep_db_prepare_input($_REQUEST['confirmation']);
              
                $error = false;
              
                if (ACCOUNT_GENDER == 'true') {
                  if ( ($gender != 'm') && ($gender != 'f') ) {
                    $error = true;

                    $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_GENDER_ERROR, array('type'=>'create_account_error'));

                  }
                }
              
                if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
                  $error = true;
              
                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_FIRST_NAME_ERROR, array('type'=>'create_account_error'));
                }

                if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
                  $error = true;

                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_LAST_NAME_ERROR, array('type'=>'create_account_error'));
                }

                if (ACCOUNT_DOB == 'true') {
                  if (checkdate(substr(tep_date_raw($dob), 4, 2), substr(tep_date_raw($dob), 6, 2), substr(tep_date_raw($dob), 0, 4)) == false) {
                    $error = true;

                    $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_DATE_OF_BIRTH_ERROR, array('type'=>'create_account_error'));
                  }
                }
              
                if (strlen($email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
                  $error = true;

                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_EMAIL_ADDRESS_ERROR, array('type'=>'create_account_error'));
                } elseif (tep_validate_email($email_address) == false) {
                  $error = true;

                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_EMAIL_ADDRESS_CHECK_ERROR, array('type'=>'create_account_error'));
                } else {
                  $check_email_query = tep_db_query("select count(*) as total from " . TABLE_CUSTOMERS . " where customers_email_address = '" . tep_db_input($email_address) . "'");
                  $check_email = tep_db_fetch_array($check_email_query);
                  if ($check_email['total'] > 0) {
                    $error = true;
              
                    $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_EMAIL_ADDRESS_ERROR_EXISTS, array('type'=>'create_account_error'));
                  }
                }

                if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
                  $error = true;

                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_STREET_ADDRESS_ERROR, array('type'=>'create_account_error'));
                }
              
                if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
                  $error = true;

                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_POST_CODE_ERROR, array('type'=>'create_account_error'));
                }
              
                if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
                  $error = true;

                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_CITY_ERROR, array('type'=>'create_account_error'));
                }
              
                if (is_numeric($country) == false) {
                  $error = true;

                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_COUNTRY_ERROR, array('type'=>'create_account_error'));
                }
              
                if (ACCOUNT_STATE == 'true') {
                  $zone_id = 0;
                  $check_query = tep_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "'");
                  $check = tep_db_fetch_array($check_query);
                  $entry_state_has_zones = ($check['total'] > 0);
                  if ($entry_state_has_zones == true) {
                    $zone_query = tep_db_query("select distinct zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' and (zone_name like '" . tep_db_input($state) . "%' or zone_code like '%" . tep_db_input($state) . "%')");
                    if (tep_db_num_rows($zone_query) == 1) {
                      $zone = tep_db_fetch_array($zone_query);
                      $zone_id = $zone['zone_id'];
                    } else {
                      $error = true;
                      $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_STATE_ERROR_SELECT, array('type'=>'create_account_error'));
                    }
                  } else {
                    if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {
                      $error = true;
                      $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_STATE_ERROR, array('type'=>'create_account_error'));
                    }
                  }
                }
              
                if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
                  $error = true;
                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_TELEPHONE_NUMBER_ERROR, array('type'=>'create_account_error'));
                }
              
              
                if (strlen($password) < ENTRY_PASSWORD_MIN_LENGTH) {
                  $error = true;
              
                  $messageStack->add('create_account', ENTRY_PASSWORD_ERROR);
                } elseif ($password != $confirmation) {
                  $error = true;
                  $variable_validation_errors_xml .= crex_xml_data_node(ENTRY_PASSWORD_ERROR_NOT_MATCHING, array('type'=>'create_account_error'));

                }
              
                if ($error == false) {
                  $sql_data_array = array('customers_firstname' => $firstname,
                                          'customers_lastname' => $lastname,
                                          'customers_email_address' => $email_address,
                                          'customers_telephone' => $telephone,
                                          'customers_fax' => $fax,
                                          'customers_newsletter' => $newsletter,
                                          'customers_password' => tep_encrypt_password($password));
              
                  if (ACCOUNT_GENDER == 'true') $sql_data_array['customers_gender'] = $gender;
                  if (ACCOUNT_DOB == 'true') $sql_data_array['customers_dob'] = tep_date_raw($dob);
              
                  tep_db_perform(TABLE_CUSTOMERS, $sql_data_array);
              
                  $customer_id = tep_db_insert_id();
              
                  $sql_data_array = array('customers_id' => $customer_id,
                                          'entry_firstname' => $firstname,
                                          'entry_lastname' => $lastname,
                                          'entry_street_address' => $street_address,
                                          'entry_postcode' => $postcode,
                                          'entry_city' => $city,
                                          'entry_country_id' => $country);
              
                  if (ACCOUNT_GENDER == 'true') $sql_data_array['entry_gender'] = $gender;
                  if (ACCOUNT_COMPANY == 'true') $sql_data_array['entry_company'] = $company;
                  if (ACCOUNT_SUBURB == 'true') $sql_data_array['entry_suburb'] = $suburb;
                  if (ACCOUNT_STATE == 'true') {
                    if ($zone_id > 0) {
                      $sql_data_array['entry_zone_id'] = $zone_id;
                      $sql_data_array['entry_state'] = '';
                    } else {
                      $sql_data_array['entry_zone_id'] = '0';
                      $sql_data_array['entry_state'] = $state;
                    }
                  }
              
                  tep_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);
              
                  $address_id = tep_db_insert_id();
              
                  tep_db_query("update " . TABLE_CUSTOMERS . " set customers_default_address_id = '" . (int)$address_id . "' where customers_id = '" . (int)$customer_id . "'");
              
                  tep_db_query("insert into " . TABLE_CUSTOMERS_INFO . " (customers_info_id, customers_info_number_of_logons, customers_info_date_account_created) values ('" . (int)$customer_id . "', '0', now())");
              
                  if (SESSION_RECREATE == 'True') {
                    tep_session_recreate();
                  }
              
                  $customer_first_name = $firstname;
                  $customer_default_address_id = $address_id;
                  $customer_country_id = $country;
                  $customer_zone_id = $zone_id;
                  tep_session_register('customer_id');
                  tep_session_register('customer_first_name');
                  tep_session_register('customer_default_address_id');
                  tep_session_register('customer_country_id');
                  tep_session_register('customer_zone_id');
              
              // restore cart contents
                  $cart->restore_contents();
              
              // build the message content
                  $name = $firstname . ' ' . $lastname;
              
                  if (ACCOUNT_GENDER == 'true') {
                     if ($gender == 'm') {
                       $email_text = sprintf(EMAIL_GREET_MR, $lastname);
                     } else {
                       $email_text = sprintf(EMAIL_GREET_MS, $lastname);
                     }
                  } else {
                    $email_text = sprintf(EMAIL_GREET_NONE, $firstname);
                  }

                  $email_text .= EMAIL_WELCOME . EMAIL_TEXT . EMAIL_CONTACT . EMAIL_WARNING;
                  tep_mail($name, $email_address, EMAIL_SUBJECT, $email_text, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
                  $crex_xml_output = crex_xml_root_node( crex_xml_data_node(crex_xml_cdata(FILENAME_CREATE_ACCOUNT_SUCCESS), array('return'=>'true')) );

                }
              } else {
                $error = true;
                $variable_validation_errors_xml .= crex_xml_data_node("ERROR: No information supplied.", array('type'=>'create_account_error'));
              }
              if ($error){
                $crex_xml_output = crex_create_error_data_document($variable_validation_errors_xml);
              }
             // --------------------  User "create_account" routine EOF ---------------

             // -------------------- Breadcrumb for "create_account" BOF --------------
             $breadcrumb->add(NAVBAR_TITLE, tep_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'));
             // -------------------- Breadcrumb for "create_account" EOF --------------
             break;
        case 'checkout_confirmation':
             //TODO: implement checkout routine.
             //TODO: Requires login before continuing (login/register)
             break;
        case 'product_add_to_cart':
             //NOTE: adds product to "cart" via the application_top.php $cart object.

             $product_id = crex_request('products_id');
             $pid_xml_result = '';

             $qty = crex_request('qty'); if ($qty<1) $qty = 1;
             $attributes = crex_request('attributes');
             $notify = crex_request('notify');

             //NOTE: $cart object (shopping_cart class) was created by "application_top.php"
             $cart->add_cart($products_id, $qty, $attributes, $notify);

             //NOTE: Return list of cart contents in CDATA tag.
             $prod_array = $cart->get_products();

             foreach($prod_array as $key => $product){
               $pid_xml_result .= crex_xml_data_node(crex_xml_cdata(htmlentities($product['name'], ENT_QUOTES)),array('pid'=>htmlentities($product['id'], ENT_QUOTES),
                                                                                'name'=>htmlentities($product['name'], ENT_QUOTES),
                                                                                'model'=>htmlentities($product['model'], ENT_QUOTES),
                                                                                'image'=>htmlentities($product['image'], ENT_QUOTES),
                                                                                'price'=>htmlentities($product['price'], ENT_QUOTES),
                                                                                'quantity'=>htmlentities($product['quantity'], ENT_QUOTES),
                                                                                'weight'=>htmlentities($product['weight'], ENT_QUOTES),
                                                                                'final_price'=>htmlentities($product['final_price'], ENT_QUOTES),
                                                                                'tax_class_id'=>htmlentities($product['products_tax_class_id'], ENT_QUOTES),
                                                                                'attributes'=>htmlentities($product['attributes'], ENT_QUOTES)));
             }

             $crex_xml_output = crex_xml_root_node($pid_xml_result, array('count_contents'=>$cart->count_contents()));

             break;
        case 'product_update_quantity':
             $product_id = crex_request('products_id');

             $qty = crex_request('qty');
             $attributes = crex_request('attributes');
             $cart->update_quantity($products_id, $qty, $attributes);

             //NOTE: Return list of cart contents in CDATA tag.
             $prod_array = $cart->get_products();

             foreach($prod_array as $key => $product){
               $pid_xml_result .= crex_xml_data_node(crex_xml_cdata(htmlentities($product['name'], ENT_QUOTES)),array('pid'=>htmlentities($product['id'], ENT_QUOTES),
                                                                                'name'=>htmlentities($product['name'], ENT_QUOTES),
                                                                                'model'=>htmlentities($product['model'], ENT_QUOTES),
                                                                                'image'=>htmlentities($product['image'], ENT_QUOTES),
                                                                                'price'=>htmlentities($product['price'], ENT_QUOTES),
                                                                                'quantity'=>htmlentities($product['quantity'], ENT_QUOTES),
                                                                                'weight'=>htmlentities($product['weight'], ENT_QUOTES),
                                                                                'final_price'=>htmlentities($product['final_price'], ENT_QUOTES),
                                                                                'tax_class_id'=>htmlentities($product['products_tax_class_id'], ENT_QUOTES),
                                                                                'attributes'=>htmlentities($product['attributes'], ENT_QUOTES)));
             }

             $crex_xml_output = crex_xml_root_node($pid_xml_result, array('count_contents'=>$cart->count_contents()));
             break;
        case 'product_remove_from_cart':
             //NOTE: removes selected product(s) from cart.
             $product_id = crex_request('products_id');
             $cart->remove($product_id);
             
             //NOTE: Return list of cart contents in CDATA tag.
             $prod_array = $cart->get_products();

             foreach($prod_array as $key => $product){
               $pid_xml_result .= crex_xml_data_node(crex_xml_cdata(htmlentities($product['name'], ENT_QUOTES)),array('pid'=>htmlentities($product['id'], ENT_QUOTES),
                                                                                'name'=>htmlentities($product['name'], ENT_QUOTES),
                                                                                'model'=>htmlentities($product['model'], ENT_QUOTES),
                                                                                'image'=>htmlentities($product['image'], ENT_QUOTES),
                                                                                'price'=>htmlentities($product['price'], ENT_QUOTES),
                                                                                'quantity'=>htmlentities($product['quantity'], ENT_QUOTES),
                                                                                'weight'=>htmlentities($product['weight'], ENT_QUOTES),
                                                                                'final_price'=>htmlentities($product['final_price'], ENT_QUOTES),
                                                                                'tax_class_id'=>htmlentities($product['products_tax_class_id'], ENT_QUOTES),
                                                                                'attributes'=>htmlentities($product['attributes'], ENT_QUOTES)));
             }

             $crex_xml_output = crex_xml_root_node($pid_xml_result, array('count_contents'=>$cart->count_contents()));
             break;
        case 'retrieve_cart';
             //NOTE: Return list of cart contents in CDATA tag.
                          
             $prod_array = $cart->get_products();

             foreach($prod_array as $key => $product){
               $pid_xml_result .= crex_xml_data_node(crex_xml_cdata(htmlentities($product['name'], ENT_QUOTES)),array('pid'=>htmlentities($product['id'], ENT_QUOTES),
                                                                                'name'=>htmlentities($product['name'], ENT_QUOTES),
                                                                                'model'=>htmlentities($product['model'], ENT_QUOTES),
                                                                                'image'=>htmlentities($product['image'], ENT_QUOTES),
                                                                                'price'=>htmlentities($product['price'], ENT_QUOTES),
                                                                                'quantity'=>htmlentities($product['quantity'], ENT_QUOTES),
                                                                                'weight'=>htmlentities($product['weight'], ENT_QUOTES),
                                                                                'final_price'=>htmlentities($product['final_price'], ENT_QUOTES),
                                                                                'tax_class_id'=>htmlentities($product['products_tax_class_id'], ENT_QUOTES),
                                                                                'attributes'=>htmlentities($product['attributes'], ENT_QUOTES)));
             }

             $crex_xml_output = crex_xml_root_node($pid_xml_result, array('count_contents'=>$cart->count_contents()));
             break;
        case 'product_delete_cart':
             //NOTE: Removes all products in cart, and cart in db. (empty the cart).
             $cart->reset(true);
             //NOTE: Return list of cart contents in CDATA tag.
             $prod_array = $cart->get_products();

             foreach($prod_array as $key => $product){
               $pid_xml_result .= crex_xml_data_node(crex_xml_cdata(htmlentities($product['name'], ENT_QUOTES)),array('pid'=>htmlentities($product['id'], ENT_QUOTES),
                                                                                'name'=>htmlentities($product['name'], ENT_QUOTES),
                                                                                'model'=>htmlentities($product['model'], ENT_QUOTES),
                                                                                'image'=>htmlentities($product['image'], ENT_QUOTES),
                                                                                'price'=>htmlentities($product['price'], ENT_QUOTES),
                                                                                'quantity'=>htmlentities($product['quantity'], ENT_QUOTES),
                                                                                'weight'=>htmlentities($product['weight'], ENT_QUOTES),
                                                                                'final_price'=>htmlentities($product['final_price'], ENT_QUOTES),
                                                                                'tax_class_id'=>htmlentities($product['products_tax_class_id'], ENT_QUOTES),
                                                                                'attributes'=>htmlentities($product['attributes'], ENT_QUOTES)));
             }

             $crex_xml_output = crex_xml_root_node($pid_xml_result, array('count_contents'=>$cart->count_contents()));
             break;
        case 'product_add_to_wish_list':
             //TODO: add  item(s) to wish list. see osC code.

             break;
        case 'product_remove_from_wish_list':
             //TODO: remove item(s) from wish list. see osC code.

             break;
        case 'product_search':
             //NOTE: Implement osC advanced search feature here. (advanced_search_result.php)

             include(DIR_WS_LANGUAGES . $languages_dir . '/' . FILENAME_ADVANCED_SEARCH);
             $keywords = $_REQUEST['keywords'];
             $dfrom = $_REQUEST['dfrom'];
             $dto = $_REQUEST['dto'];
             $pfrom = $_REQUEST['pfrom'];
             $pto = $_REQUEST['pto'];
             $error = false;

             //------ Search Variable(s) validation BOF ----------
             $vars_submitted = ((isset($keywords) && empty($keywords)) &&
                 (isset($dfrom) && (empty($dfrom) || ($dfrom == DOB_FORMAT_STRING))) &&
                 (isset($dto) && (empty($dto) || ($dto == DOB_FORMAT_STRING))) &&
                 (isset($pfrom) && !is_numeric($pfrom) && (isset($pto) && !is_numeric($pto))));

             if ($vars_submitted){

                //ERROR: No search terms were submitted! Return message ERROR_AT_LEAST_ONE_INPUT
                $crex_xml_output = crex_create_error_document('ERROR #A2: '.ERROR_AT_LEAST_ONE_INPUT);
             } else {
               //TODO: 1 or more search terms retrieved... continue creating search list.
               //------ Variable validation BOF ----------
               if (isset($_REQUEST['dfrom'])) {
                 $dfrom = (($_REQUEST['dfrom'] == DOB_FORMAT_STRING) ? '' : $_REQUEST['dfrom']);
               }

               if (isset($_REQUEST['dto'])) {
                 $dto = (($_REQUEST['dto'] == DOB_FORMAT_STRING) ? '' : $_REQUEST['dto']);
               }

               if (isset($_REQUEST['pfrom'])) {
                 $pfrom = $_REQUEST['pfrom'];
               }

               if (isset($_REQUEST['pto'])) {
                 $pto = $_REQUEST['pto'];
               }

               if (isset($_REQUEST['keywords'])) {
                 $keywords = $_REQUEST['keywords'];
               }
               //------ Variable validation EOF ----------
               //------ Date variable(s) validation BOF ----------
               $date_check_error = false;
               $variable_validation_errors_xml = '';

               if (tep_not_null($dfrom)) {
                 if (!tep_checkdate($dfrom, DOB_FORMAT_STRING, $dfrom_array)) {
                   $error = true;
                   $date_check_error = true;

                   $variable_validation_errors_xml .= crex_xml_data_node(ERROR_INVALID_FROM_DATE, array('type'=>'search_error'));
                 }
               }

               if (tep_not_null($dto)) {
                 if (!tep_checkdate($dto, DOB_FORMAT_STRING, $dto_array)) {
                   $error = true;
                   $date_check_error = true;

                   $variable_validation_errors_xml .= crex_xml_data_node(ERROR_INVALID_TO_DATE, array('type'=>'search_error'));
                 }
               }

               if (($date_check_error == false) && tep_not_null($dfrom) && tep_not_null($dto)) {
                 if (mktime(0, 0, 0, $dfrom_array[1], $dfrom_array[2], $dfrom_array[0]) > mktime(0, 0, 0, $dto_array[1], $dto_array[2], $dto_array[0])) {
                   $error = true;

                   $variable_validation_errors_xml .= crex_xml_data_node(ERROR_TO_DATE_LESS_THAN_FROM_DATE, array('type'=>'search_error'));
                 }
               }
               //------ Date variable(s) validation EOF ----------
               //------ Price variable(s) validation BOF ----------
               $price_check_error = false;
               if (tep_not_null($pfrom)) {
                 if (!settype($pfrom, 'double')) {
                   $error = true;
                   $price_check_error = true;

                   $variable_validation_errors_xml .= crex_xml_data_node(ERROR_PRICE_FROM_MUST_BE_NUM, array('type'=>'search_error'));
                 }
               }

               if (tep_not_null($pto)) {
                 if (!settype($pto, 'double')) {
                   $error = true;
                   $price_check_error = true;

                   $variable_validation_errors_xml .= crex_xml_data_node(ERROR_PRICE_TO_MUST_BE_NUM, array('type'=>'search_error'));
                 }
               }

               if (($price_check_error == false) && is_float($pfrom) && is_float($pto)) {
                 if ($pfrom >= $pto) {
                   $error = true;

                   $variable_validation_errors_xml .= crex_xml_data_node(ERROR_PRICE_TO_LESS_THAN_PRICE_FROM, array('type'=>'search_error'));
                 }
               }

               if (tep_not_null($keywords)) {
                 if (!tep_parse_search_string($keywords, $search_keywords)) {
                   $error = true;

                   $variable_validation_errors_xml .= crex_xml_data_node(ERROR_INVALID_KEYWORDS, array('type'=>'search_error'));
                 }
               }
               //------ Price variable(s) validation EOF ----------
             }
             //------ Search Variable(s) validation EOF ----------
             //------ Field(s) validation BOF ----------
             if (empty($dfrom) && empty($dto) && empty($pfrom) && empty($pto) && empty($keywords)) {
               $error = true;

               $messageStack->add_session('search', ERROR_AT_LEAST_ONE_INPUT);
             }
             //------ Field(s) validation EOF ----------
             //------ Search Result BOF ----------
             if ($error == true){
               //NOTE: Cannot retreive product(s). Search encountered variable validation errors.
               $crex_xml_output = crex_create_error_data_document($variable_validation_errors_xml);
             } else {
               //NOTE: no errors raised. Continue to create SQL query, and return result(s).
               //NOTE: -DONE(application_top.php handles this)-keep track of tep_session_is_registered('customer_country_id') (sql query builder checks to see if it exists.)

               // create column list
                $define_list = array('PRODUCT_LIST_MODEL' => PRODUCT_LIST_MODEL,
                                     'PRODUCT_LIST_NAME' => PRODUCT_LIST_NAME,
                                     'PRODUCT_LIST_MANUFACTURER' => PRODUCT_LIST_MANUFACTURER,
                                     'PRODUCT_LIST_PRICE' => PRODUCT_LIST_PRICE,
                                     'PRODUCT_LIST_QUANTITY' => PRODUCT_LIST_QUANTITY,
                                     'PRODUCT_LIST_WEIGHT' => PRODUCT_LIST_WEIGHT,
                                     'PRODUCT_LIST_IMAGE' => PRODUCT_LIST_IMAGE,
                                     'PRODUCT_LIST_BUY_NOW' => PRODUCT_LIST_BUY_NOW);

                asort($define_list);

                $column_list = array();
                reset($define_list);
                while (list($key, $value) = each($define_list)) {
                  if ($value > 0) $column_list[] = $key;
                }

                $select_column_list = '';

                for ($i=0, $n=sizeof($column_list); $i<$n; $i++) {
                  switch ($column_list[$i]) {
                    case 'PRODUCT_LIST_MODEL':
                      $select_column_list .= 'p.products_model, ';
                      break;
                    case 'PRODUCT_LIST_MANUFACTURER':
                      $select_column_list .= 'm.manufacturers_name, ';
                      break;
                    case 'PRODUCT_LIST_QUANTITY':
                      $select_column_list .= 'p.products_quantity, ';
                      break;
                    case 'PRODUCT_LIST_IMAGE':
                      $select_column_list .= 'p.products_image, ';
                      break;
                    case 'PRODUCT_LIST_WEIGHT':
                      $select_column_list .= 'p.products_weight, ';
                      break;
                  }
                }

                $select_str = "select distinct " . $select_column_list . " m.manufacturers_id, p.products_id, pd.products_name, p.products_price, p.products_tax_class_id, IF(s.status, s.specials_new_products_price, NULL) as specials_new_products_price, IF(s.status, s.specials_new_products_price, p.products_price) as final_price ";

                if ( (DISPLAY_PRICE_WITH_TAX == 'true') && (tep_not_null($pfrom) || tep_not_null($pto)) ) {
                  $select_str .= ", SUM(tr.tax_rate) as tax_rate ";
                }

                $from_str = "from " . TABLE_PRODUCTS . " p left join " . TABLE_MANUFACTURERS . " m using(manufacturers_id) left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id";

                if ( (DISPLAY_PRICE_WITH_TAX == 'true') && (tep_not_null($pfrom) || tep_not_null($pto)) ) {
                  if (!tep_session_is_registered('customer_country_id')) {
                    $customer_country_id = STORE_COUNTRY;
                    $customer_zone_id = STORE_ZONE;
                  }
                  $from_str .= " left join " . TABLE_TAX_RATES . " tr on p.products_tax_class_id = tr.tax_class_id left join " . TABLE_ZONES_TO_GEO_ZONES . " gz on tr.tax_zone_id = gz.geo_zone_id and (gz.zone_country_id is null or gz.zone_country_id = '0' or gz.zone_country_id = '" . (int)$customer_country_id . "') and (gz.zone_id is null or gz.zone_id = '0' or gz.zone_id = '" . (int)$customer_zone_id . "')";
                }

                $from_str .= ", " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_CATEGORIES . " c, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c";

                $where_str = " where p.products_status = '1' and p.products_id = pd.products_id and pd.language_id = '" . (int)$languages_id . "' and p.products_id = p2c.products_id and p2c.categories_id = c.categories_id ";
                //INSTRUCTIONS: search query builder looks for the following optional $_REQUEST vars:
                //categories_id, inc_subcat, manufacturers_id, search_in_description,sort[]
                //
                //the "sort" $_REQUEST var decides the sort order (d for "desc", otherwise "", for default).
                //it is also in charge of the column "order by" query (order by PRODUCT_LIST_MODEL, PRODUCT_LIST_NAME, PRODUCT_LIST_MANUFACTURER, PRODUCT_LIST_QUANTITY
                //PRODUCT_LIST_IMAGE, PRODUCT_LIST_WEIGHT, or PRODUCT_LIST_PRICE),

                if (isset($_REQUEST['categories_id']) && tep_not_null($_REQUEST['categories_id'])) {
                  if (isset($_REQUEST['inc_subcat']) && ($_REQUEST['inc_subcat'] == '1')) {
                    $subcategories_array = array();
                    tep_get_subcategories($subcategories_array, $_REQUEST['categories_id']);

                    $where_str .= " and p2c.products_id = p.products_id and p2c.products_id = pd.products_id and (p2c.categories_id = '" . (int)$_REQUEST['categories_id'] . "'";

                    for ($i=0, $n=sizeof($subcategories_array); $i<$n; $i++ ) {
                      $where_str .= " or p2c.categories_id = '" . (int)$subcategories_array[$i] . "'";
                    }

                    $where_str .= ")";
                  } else {
                    $where_str .= " and p2c.products_id = p.products_id and p2c.products_id = pd.products_id and pd.language_id = '" . (int)$languages_id . "' and p2c.categories_id = '" . (int)$_REQUEST['categories_id'] . "'";
                  }
                }

                if (isset($_REQUEST['manufacturers_id']) && tep_not_null($_REQUEST['manufacturers_id'])) {
                  $where_str .= " and m.manufacturers_id = '" . (int)$_REQUEST['manufacturers_id'] . "'";
                }

                if (isset($search_keywords) && (sizeof($search_keywords) > 0)) {
                  $where_str .= " and (";
                  for ($i=0, $n=sizeof($search_keywords); $i<$n; $i++ ) {
                    switch ($search_keywords[$i]) {
                      case '(':
                      case ')':
                      case 'and':
                      case 'or':
                        $where_str .= " " . $search_keywords[$i] . " ";
                        break;
                      default:
                        $keyword = tep_db_prepare_input($search_keywords[$i]);
                        $where_str .= "(pd.products_name like '%" . tep_db_input($keyword) . "%' or p.products_model like '%" . tep_db_input($keyword) . "%' or m.manufacturers_name like '%" . tep_db_input($keyword) . "%'";
                        if (isset($_REQUEST['search_in_description']) && ($_REQUEST['search_in_description'] == '1')) $where_str .= " or pd.products_description like '%" . tep_db_input($keyword) . "%'";
                        $where_str .= ')';
                        break;
                    }
                  }
                  $where_str .= " )";
                }

                if (tep_not_null($dfrom)) {
                  $where_str .= " and p.products_date_added >= '" . tep_date_raw($dfrom) . "'";
                }

                if (tep_not_null($dto)) {
                  $where_str .= " and p.products_date_added <= '" . tep_date_raw($dto) . "'";
                }

                if (tep_not_null($pfrom)) {
                  if ($currencies->is_set($currency)) {
                    $rate = $currencies->get_value($currency);

                    $pfrom = $pfrom / $rate;
                  }
                }

                if (tep_not_null($pto)) {
                  if (isset($rate)) {
                    $pto = $pto / $rate;
                  }
                }

                if (DISPLAY_PRICE_WITH_TAX == 'true') {
                  if ($pfrom > 0) $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) * if(gz.geo_zone_id is null, 1, 1 + (tr.tax_rate / 100) ) >= " . (double)$pfrom . ")";
                  if ($pto > 0) $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) * if(gz.geo_zone_id is null, 1, 1 + (tr.tax_rate / 100) ) <= " . (double)$pto . ")";
                } else {
                  if ($pfrom > 0) $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) >= " . (double)$pfrom . ")";
                  if ($pto > 0) $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) <= " . (double)$pto . ")";
                }

                if ( (DISPLAY_PRICE_WITH_TAX == 'true') && (tep_not_null($pfrom) || tep_not_null($pto)) ) {
                  $where_str .= " group by p.products_id, tr.tax_priority";
                }

                if ( (!isset($_REQUEST['sort'])) || (!ereg('[1-8][ad]', $_REQUEST['sort'])) || (substr($_REQUEST['sort'], 0, 1) > sizeof($column_list)) ) {
                  for ($i=0, $n=sizeof($column_list); $i<$n; $i++) {
                    if ($column_list[$i] == 'PRODUCT_LIST_NAME') {
                      $_REQUEST['sort'] = $i+1 . 'a';
                      $order_str = ' order by pd.products_name';
                      break;
                    }
                  }
                } else {
                  $sort_col = substr($_REQUEST['sort'], 0 , 1);
                  $sort_order = substr($_REQUEST['sort'], 1);
                  $order_str = ' order by ';

                  switch ($column_list[$sort_col-1]) {
                    case 'PRODUCT_LIST_MODEL':
                      $order_str .= "p.products_model " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name";
                      break;
                    case 'PRODUCT_LIST_NAME':
                      $order_str .= "pd.products_name " . ($sort_order == 'd' ? "desc" : "");
                      break;
                    case 'PRODUCT_LIST_MANUFACTURER':
                      $order_str .= "m.manufacturers_name " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name";
                      break;
                    case 'PRODUCT_LIST_QUANTITY':
                      $order_str .= "p.products_quantity " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name";
                      break;
                    case 'PRODUCT_LIST_IMAGE':
                      $order_str .= "pd.products_name";
                      break;
                    case 'PRODUCT_LIST_WEIGHT':
                      $order_str .= "p.products_weight " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name";
                      break;
                    case 'PRODUCT_LIST_PRICE':
                      $order_str .= "final_price " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name";
                      break;
                  }
                }

                $listing_sql = $select_str . $from_str . $where_str . $order_str;

                $crex_xml_output = crex_sql_query_to_xml_document(array('query'=>$listing_sql, 'language_id'=>$languages_id));
             }
             //------ Search Result EOF ----------
             break;
        case 'get_categories':
             //NOTE: Retrieves categories.
             $crex_xml_output = crex_get_categories_xml(array('language_id'=>$languages_id));
             break;
        case 'get_category_products':
             //NOTE: retrieves product id(s) of products in the selected cpath (category path/id)
             $crex_cpath = crex_request('cpath');
             $crex_xml_output = crex_xml_root_node(crex_get_category_products_xml($crex_cpath, $languages_id));

             break;
        case 'get_category_product_count':
             //NOTE: returns amount of products in category.
             $crex_cpath = crex_request('cpath');
             $crex_xml_output = crex_xml_root_node(crex_xml_data_node(tep_count_products_in_category($crex_cpath)));

             break;
        case 'get_product':
             //NOTE: Retrieve information about the specified product.
             $crex_prod_id = crex_request('pid');
             $crex_xml_output = crex_get_product_xml($crex_prod_id, $languages_id);
             break;
        default:
             //ERROR: Command not found.
             $crex_xml_output = crex_create_error_document('ERROR #A1: Invalid command.');
             break;
      }
      echo $crex_xml_doctype.$crex_xml_output."\n\n";

include('includes/crex_application_bottom_cre.php');
exit;


?>
